% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCCA.R
\name{runCCA}
\alias{runCCA}
\alias{calculateCCA}
\alias{calculateRDA}
\alias{runRDA}
\alias{calculateCCA,ANY-method}
\alias{calculateCCA,SummarizedExperiment-method}
\alias{runCCA,SingleCellExperiment-method}
\alias{calculateRDA,ANY-method}
\alias{calculateRDA,SummarizedExperiment-method}
\alias{runRDA,SingleCellExperiment-method}
\title{Canonical Correspondence Analysis and Redundancy Analysis}
\usage{
calculateCCA(x, ...)

runCCA(x, ...)

calculateRDA(x, ...)

runRDA(x, ...)

\S4method{calculateCCA}{ANY}(x, ...)

\S4method{calculateCCA}{SummarizedExperiment}(
  x,
  formula,
  variables,
  test.signif = TRUE,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  scores = "wa",
  ...
)

\S4method{runCCA}{SingleCellExperiment}(x, formula, variables, altexp = NULL, name = "CCA", ...)

\S4method{calculateRDA}{ANY}(x, ...)

\S4method{calculateRDA}{SummarizedExperiment}(
  x,
  formula,
  variables,
  test.signif = TRUE,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  scores = "wa",
  ...
)

\S4method{runRDA}{SingleCellExperiment}(x, formula, variables, altexp = NULL, name = "RDA", ...)
}
\arguments{
\item{x}{For \code{calculate*} a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
or a numeric matrix with columns as samples

For \code{run*} a
\code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}}
or a derived object.}

\item{...}{additional arguments passed to vegan::cca or vegan::dbrda and
other internal functions.
\itemize{
\item{\code{method} a dissimilarity measure to be applied in dbRDA and
possible following homogeneity test. (By default: \code{method="euclidean"})}
\item{\code{scale} a logical scalar, should the expression values be
standardized? \code{scale} is disabled when using \code{*RDA} functions.
Please scale before performing RDA. (By default: \code{scale=TRUE})}
\item{\code{full} a logical scalar, should all the results from the
significance calculations be returned. When \code{full=FALSE}, only
summary tables are returned. (By default: \code{full=FALSE})}
\item{\code{homogeneity.test} a single \code{character} value for specifying
the significance test used to analyse \code{vegan::betadisper} results.
Options include 'permanova' (\code{vegan::permutest}), 'anova'
(\code{stats::anova}) and 'tukeyhsd' (\code{stats::TukeyHSD}).
(By default: \code{homogeneity.test="permanova"})}
}}

\item{formula}{If \code{x} is a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
a formula can be supplied. Based on the right-hand side of the given formula
\code{colData} is subset to \code{variables}.

\code{variables} and \code{formula} can be missing, which turns the CCA analysis
into a CA analysis and dbRDA into PCoA/MDS.}

\item{variables}{When \code{x} is a \code{SummarizedExperiment},
\code{variables} can be used to specify variables from \code{colData}.

When \code{x} is a matrix, \code{variables} is a \code{data.frame} or
an object coercible to one containing the variables to use.

All variables are used. Please subset, if you want to consider only some of them.
\code{variables} and \code{formula} can be missing, which turns the CCA analysis
into a CA analysis and dbRDA into PCoA/MDS.}

\item{test.signif}{a logical scalar, should the PERMANOVA and analysis of
multivariate homogeneity of group dispersions be performed.
(By default: \code{test.signif = TRUE})}

\item{assay.type}{a single \code{character} value for specifying which
assay to use for calculation.}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{exprs_values}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead.)}

\item{scores}{A string specifying scores to be returned. Must be
'wa' (site scores found as weighted averages (cca) or weighted sums (rda) of
v with weights Xbar, but the multiplying effect of eigenvalues removed) or
'u' ((weighted) orthonormal site scores). (By default: \code{scores='wa'})}

\item{altexp}{String or integer scalar specifying an alternative experiment
containing the input data.}

\item{name}{String specifying the name to be used to store the result in the
reducedDims of the output.}
}
\value{
For \code{calculateCCA} a matrix with samples as rows and CCA dimensions as
columns. Attributes include calculated \code{cca}/\code{rda} object and
significance analysis results.

For \code{runCCA} a modified \code{x} with the results stored in
\code{reducedDim} as the given \code{name}.
}
\description{
These functions perform Canonical Correspondence Analysis on data stored
in a \code{SummarizedExperiment}.
}
\details{
*CCA functions utilize \code{vegan:cca} and *RDA functions \code{vegan:dbRDA}.
By default dbRDA is done with euclidean distances which equals to RDA.

Significance tests are done with \code{vegan:anova.cca} (PERMANOVA). Group
dispersion, i.e., homogeneity within groups is analyzed with
\code{vegan:betadisper} (multivariate homogeneity of groups dispersions (variances))
and statistical significance of homogeneity is tested with a test
specified by \code{homogeneity.test} parameter.
}
\examples{
library(scater)
data(GlobalPatterns)
GlobalPatterns <- runCCA(GlobalPatterns, data ~ SampleType)
plotReducedDim(GlobalPatterns,"CCA", colour_by = "SampleType")

# Fetch significance results
attr(reducedDim(GlobalPatterns, "CCA"), "significance")

GlobalPatterns <- runRDA(GlobalPatterns, data ~ SampleType)
plotReducedDim(GlobalPatterns,"CCA", colour_by = "SampleType")

# Specify dissimilarity measure
GlobalPatterns <- transformAssay(GlobalPatterns, method = "relabundance")
GlobalPatterns <- runRDA(
    GlobalPatterns, data ~ SampleType, assay.type = "relabundance",  method = "bray")

# To scale values when using *RDA functions, use transformAssay(MARGIN = "features", ...) 
tse <- GlobalPatterns
tse <- transformAssay(tse, MARGIN = "features", method = "z")
# Data might include taxa that do not vary. Remove those because after z-transform
# their value is NA
tse <- tse[ rowSums( is.na( assay(tse, "z") ) ) == 0, ]
# Calculate RDA
tse <- runRDA(tse, formula = data ~ SampleType,
              assay.type = "z", name = "rda_scaled", na.action = na.omit)
# Plot
plotReducedDim(tse,"rda_scaled", colour_by = "SampleType")
# A common choice along with PERMANOVA is ANOVA when statistical significance
# of homogeneity of groups is analysed. Moreover, full signficance test results
# can be returned.
 tse <- runRDA(tse, data ~ SampleType, homogeneity.test = "anova", full = TRUE)

}
\seealso{
For more details on the actual implementation see \code{\link[vegan:cca]{cca}}
and \code{\link[vegan:dbrda]{dbrda}}
}
