% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNMDS.R
\name{runNMDS}
\alias{runNMDS}
\alias{calculateNMDS}
\alias{calculateNMDS,ANY-method}
\alias{calculateNMDS,SummarizedExperiment-method}
\alias{calculateNMDS,SingleCellExperiment-method}
\title{Perform non-metric MDS on sample-level data}
\usage{
calculateNMDS(x, ...)

\S4method{calculateNMDS}{ANY}(
  x,
  FUN = vegdist,
  nmdsFUN = c("isoMDS", "monoMDS"),
  ncomponents = 2,
  ntop = 500,
  subset_row = NULL,
  scale = FALSE,
  transposed = FALSE,
  keep_dist = FALSE,
  ...
)

\S4method{calculateNMDS}{SummarizedExperiment}(
  x,
  ...,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  FUN = vegdist
)

\S4method{calculateNMDS}{SingleCellExperiment}(
  x,
  ...,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  dimred = NULL,
  n_dimred = NULL,
  FUN = vegdist
)

runNMDS(x, ..., altexp = NULL, name = "NMDS")
}
\arguments{
\item{x}{For \code{calculateNMDS}, a numeric matrix of expression values
where rows are features and columns are cells.
Alternatively, a \code{TreeSummarizedExperiment} containing such a matrix.

For \code{runNMDS} a \linkS4class{SingleCellExperiment}}

\item{...}{additional arguments to pass to \code{FUN} and
\code{nmdsFUN}.}

\item{FUN}{a \code{function} or \code{character} value with a function
name returning a \code{\link[stats:dist]{dist}} object}

\item{nmdsFUN}{a \code{character} value to choose the scaling
implementation, either \dQuote{isoMDS} for
\code{\link[MASS:isoMDS]{MASS::isoMDS}} or \dQuote{monoMDS} for
\code{\link[vegan:monoMDS]{vegan::monoMDS}}}

\item{ncomponents}{Numeric scalar indicating the number of NMDS dimensions
to obtain.}

\item{ntop}{Numeric scalar specifying the number of features with the highest
variances to use for dimensionality reduction.}

\item{subset_row}{Vector specifying the subset of features to use for
dimensionality reduction. This can be a character vector of row names, an
integer vector of row indices or a logical vector.}

\item{scale}{Logical scalar, should the expression values be standardized?}

\item{transposed}{Logical scalar, is x transposed with cells in rows?}

\item{keep_dist}{Logical scalar indicating whether the \code{dist} object
calculated by \code{FUN} should be stored as \sQuote{dist} attribute of
the matrix returned/stored by \code{calculateNMDS}/ \code{runNMDS}.}

\item{assay.type}{a single \code{character} value for specifying which
assay to use for calculation.}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{exprs_values}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead.)}

\item{dimred}{String or integer scalar specifying the existing dimensionality
reduction results to use.}

\item{n_dimred}{Integer scalar or vector specifying the dimensions to use if
dimred is specified.}

\item{altexp}{String or integer scalar specifying an alternative experiment
containing the input data.}

\item{name}{String specifying the name to be used to store the result in the
reducedDims of the output.}
}
\value{
For \code{calculateNMDS}, a matrix is returned containing the MDS
coordinates for each sample (row) and dimension (column).
}
\description{
Perform non-metric multi-dimensional scaling (nMDS) on samples, based on the
data in a \code{SingleCellExperiment} object.
}
\details{
Either \code{\link[MASS:isoMDS]{MASS::isoMDS}} or
\code{\link[vegan:monoMDS]{vegan::monoMDS}} are used internally to compute
the NMDS components. If you supply a custom \code{FUN}, make sure that
the arguments of \code{FUN} and \code{nmdsFUN} do not collide.
}
\examples{
# generate some example data
mat <- matrix(1:60, nrow = 6)
df <- DataFrame(n = c(1:6))
tse <- TreeSummarizedExperiment(assays = list(counts = mat),
                                rowData = df)
#
calculateNMDS(tse)

#
data(esophagus)
esophagus <- runNMDS(esophagus, FUN = vegan::vegdist, name = "BC")
esophagus <- runNMDS(esophagus, FUN = vegan::vegdist, name = "euclidean",
                     method = "euclidean")
reducedDims(esophagus)
}
\seealso{
\code{\link[MASS:isoMDS]{MASS::isoMDS}},
\code{\link[vegan:monoMDS]{vegan::monoMDS}}
for NMDS component calculation.

\code{\link[scater:plotReducedDim]{plotMDS}}, to quickly visualize the
results.
}
\author{
Felix Ernst
}
