% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitByRanks.R
\name{splitByRanks}
\alias{splitByRanks}
\alias{splitByRanks,SummarizedExperiment-method}
\alias{splitByRanks,SingleCellExperiment-method}
\alias{splitByRanks,TreeSummarizedExperiment-method}
\alias{unsplitByRanks}
\alias{unsplitByRanks,SingleCellExperiment-method}
\alias{unsplitByRanks,TreeSummarizedExperiment-method}
\title{Split/Unsplit a \code{SingleCellExperiment} by taxonomic ranks}
\usage{
splitByRanks(x, ...)

\S4method{splitByRanks}{SummarizedExperiment}(x, ranks = taxonomyRanks(x), na.rm = TRUE, ...)

\S4method{splitByRanks}{SingleCellExperiment}(x, ranks = taxonomyRanks(x), na.rm = TRUE, ...)

\S4method{splitByRanks}{TreeSummarizedExperiment}(x, ranks = taxonomyRanks(x), na.rm = TRUE, ...)

unsplitByRanks(x, ...)

\S4method{unsplitByRanks}{SingleCellExperiment}(x, ranks = taxonomyRanks(x), keep_reducedDims = FALSE, ...)

\S4method{unsplitByRanks}{TreeSummarizedExperiment}(x, ranks = taxonomyRanks(x), keep_reducedDims = FALSE, ...)
}
\arguments{
\item{x}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{...}{arguments passed to \code{agglomerateByRank} function for
\code{SummarizedExperiment} objects and other functions.
See \code{\link[=agglomerate-methods]{agglomerateByRank}} for more details.}

\item{ranks}{a character vector defining taxonomic ranks. Must all be values
of \code{taxonomyRanks()} function.}

\item{na.rm}{\code{TRUE} or \code{FALSE}: Should taxa with an empty rank be
removed? Use it with caution, since results with NA on the selected rank
will be dropped. This setting can be tweaked by defining
\code{empty.fields} to your needs. (default: \code{na.rm = TRUE})}

\item{keep_reducedDims}{\code{TRUE} or \code{FALSE}: Should the
\code{reducedDims(x)} be transferred to the result? Please note, that this
breaks the link between the data used to calculate the reduced dims.
(default: \code{keep_reducedDims = FALSE})}
}
\value{
For \code{splitByRanks}: \code{SummarizedExperiment} objects in a
\code{SimpleList}.

For \code{unsplitByRanks}: \code{x}, with \code{rowData} and \code{assay}
data replaced by the unsplit data. \code{colData} of x is kept as well
and any existing \code{rowTree} is dropped as well, since existing
\code{rowLinks} are not valid anymore.
}
\description{
\code{splitByRanks} takes a \code{SummarizedExperiment}, splits it along the
taxonomic ranks, aggregates the data per rank, converts the input to a
\code{SingleCellExperiment} objects and stores the aggregated data as
alternative experiments.
}
\details{
\code{unsplitByRanks} takes these alternative experiments and flattens them
again into a single \code{SummarizedExperiment}.

\code{splitByRanks} will use by default all available taxonomic ranks, but
this can be controlled by setting \code{ranks} manually. \code{NA} values
are removed by default, since they would not make sense, if the result
should be used for \code{unsplitByRanks} at some point. The input data
remains unchanged in the returned \code{SingleCellExperiment} objects.

\code{unsplitByRanks} will remove any \code{NA} value on each taxonomic rank
so that no ambiguous data is created. In additional, a column
\code{taxonomicLevel} is created or overwritten in the \code{rowData} to
specify from which alternative experiment this originates from. This can also
be used for \code{\link[SingleCellExperiment:splitAltExps]{splitAltExps}} to
split the result along the same factor again. The input data from the base
objects is not returned, only the data from the \code{altExp()}. Be aware that
changes to \code{rowData} of the base object are not returned, whereas only
the \code{colData} of the base object is kept.
}
\examples{
data(GlobalPatterns)
# print the available taxonomic ranks
taxonomyRanks(GlobalPatterns)

# splitByRanks
altExps(GlobalPatterns) <- splitByRanks(GlobalPatterns)
altExps(GlobalPatterns)
altExp(GlobalPatterns,"Kingdom")
altExp(GlobalPatterns,"Species")

# unsplitByRanks
x <- unsplitByRanks(GlobalPatterns)
x
}
\seealso{
\code{\link[=splitOn]{splitOn}}
\code{\link[=unsplitOn]{unsplitOn}}
\code{\link[=merge-methods]{mergeRows}},
\code{\link[scuttle:sumCountsAcrossFeatures]{sumCountsAcrossFeatures}},
\code{\link[=agglomerate-methods]{agglomerateByRank}},
\code{\link[SingleCellExperiment:altExps]{altExps}},
\code{\link[SingleCellExperiment:splitAltExps]{splitAltExps}}
}
