% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitOn.R
\name{splitOn}
\alias{splitOn}
\alias{splitOn,SummarizedExperiment-method}
\alias{splitOn,SingleCellExperiment-method}
\alias{splitOn,TreeSummarizedExperiment-method}
\alias{unsplitOn}
\alias{unsplitOn,list-method}
\alias{unsplitOn,SimpleList-method}
\alias{unsplitOn,SingleCellExperiment-method}
\title{Split \code{TreeSummarizedExperiment} column-wise or row-wise based on grouping variable}
\usage{
splitOn(x, ...)

\S4method{splitOn}{SummarizedExperiment}(x, f = NULL, ...)

\S4method{splitOn}{SingleCellExperiment}(x, f = NULL, ...)

\S4method{splitOn}{TreeSummarizedExperiment}(x, f = NULL, update_rowTree = FALSE, ...)

unsplitOn(x, ...)

\S4method{unsplitOn}{list}(x, update_rowTree = FALSE, ...)

\S4method{unsplitOn}{SimpleList}(x, update_rowTree = FALSE, ...)

\S4method{unsplitOn}{SingleCellExperiment}(x, altExpNames = names(altExps(x)), keep_reducedDims = FALSE, ...)
}
\arguments{
\item{x}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object or a list of
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
objects.}

\item{...}{Arguments passed to \code{mergeRows}/\code{mergeCols} function for
\code{SummarizedExperiment} objects and other functions.
See \code{\link[=agglomerate-methods]{mergeRows}} for more details.
\itemize{
\item{\code{use_names} A single boolean value to select whether to name elements of
list by their group names.}
}}

\item{f}{A single character value for selecting the grouping variable
from \code{rowData} or \code{colData} or a \code{factor} or \code{vector}
with the same length as one of the dimensions. If \code{f} matches with both
dimensions, \code{MARGIN} must be specified.
Split by cols is not encouraged, since this is not compatible with
storing the results in \code{altExps}.}

\item{update_rowTree}{\code{TRUE} or \code{FALSE}: Should the rowTree be updated
based on splitted data? Option is enabled when \code{x} is a
\code{TreeSummarizedExperiment} object or a list of such objects.
(By default: \code{update_rowTree = FALSE})}

\item{altExpNames}{a \code{character} vector specifying the alternative experiments
to be unsplit. (By default: \code{altExpNames = names(altExps(x))})}

\item{keep_reducedDims}{\code{TRUE} or \code{FALSE}: Should the
\code{reducedDims(x)} be transferred to the result? Please note, that this
breaks the link between the data used to calculate the reduced dims.
(By default: \code{keep_reducedDims = FALSE})}
}
\value{
For \code{splitOn}: \code{SummarizedExperiment} objects in a \code{SimpleList}.

For \code{unsplitOn}: \code{x}, with \code{rowData} and \code{assay}
data replaced by the unsplit data. \code{colData} of x is kept as well
and any existing \code{rowTree} is dropped as well, since existing
\code{rowLinks} are not valid anymore.
}
\description{
Split \code{TreeSummarizedExperiment} column-wise or row-wise based on grouping variable
}
\details{
\code{splitOn} split data based on grouping variable. Splitting can be done
column-wise or row-wise. The returned value is a list of
\code{SummarizedExperiment} objects; each element containing members of each
group.
}
\examples{
data(GlobalPatterns)
tse <- GlobalPatterns
# Split data based on SampleType. 
se_list <- splitOn(tse, f = "SampleType")

# List of SE objects is returned. 
se_list

# Create arbitrary groups
rowData(tse)$group <- sample(1:3, nrow(tse), replace = TRUE)
colData(tse)$group <- sample(1:3, ncol(tse), replace = TRUE)

# Split based on rows
# Each element is named based on their group name. If you don't want to name
# elements, use use_name = FALSE. Since "group" can be found from rowdata and colData
# you must use MARGIN.
se_list <- splitOn(tse, f = "group", use_names = FALSE, MARGIN = 1)

# When column names are shared between elements, you can store the list to altExps
altExps(tse) <- se_list

altExps(tse)

# If you want to split on columns and update rowTree, you can do
se_list <- splitOn(tse, f = colData(tse)$group, update_rowTree = TRUE)

# If you want to combine groups back together, you can use unsplitBy
unsplitOn(se_list)

}
\seealso{
\code{\link[=splitByRanks]{splitByRanks}}
\code{\link[=unsplitByRanks]{unsplitByRanks}}
\code{\link[=merge-methods]{mergeRows}},
\code{\link[scuttle:sumCountsAcrossFeatures]{sumCountsAcrossFeatures}},
\code{\link[=agglomerate-methods]{agglomerateByRank}},
\code{\link[SingleCellExperiment:altExps]{altExps}},
\code{\link[SingleCellExperiment:splitAltExps]{splitAltExps}}
}
\author{
Leo Lahti and Tuomas Borman. Contact: \url{microbiome.github.io}
}
