% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subsetSamples}
\alias{subsetSamples}
\alias{subsetFeatures}
\alias{subsetTaxa}
\alias{subsetSamples,SummarizedExperiment-method}
\alias{subsetFeatures,SummarizedExperiment-method}
\alias{subsetTaxa,SummarizedExperiment-method}
\title{Subset functions}
\usage{
subsetSamples(x, ...)

subsetFeatures(x, ...)

subsetTaxa(x, ...)

\S4method{subsetSamples}{SummarizedExperiment}(x, ...)

\S4method{subsetFeatures}{SummarizedExperiment}(x, ...)

\S4method{subsetTaxa}{SummarizedExperiment}(x, ...)
}
\arguments{
\item{x}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{...}{See \code{\link[BiocGenerics:subset]{subset}}. \code{drop} is
not supported.}
}
\value{
A subset of \code{x}
}
\description{
To make a transition from \code{phyloseq} easier, the \code{subsetSamples} and
\code{subsetFeatures} functions are implemented. To avoid name clashes they are
named differently.
}
\details{
However, the use of these functions is discouraged since subsetting using
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{[}} works on
both dimension at the same time, is more flexible and is used throughout R to
subset data with two or more dimension. Therefore, these functions will be
removed in Bioconductor release 3.15 (April, 2022).
}
\examples{
data(GlobalPatterns)
subsetSamples(GlobalPatterns, colData(GlobalPatterns)$SampleType == "Soil")
# Vector that is used to specify subset must not include NAs 
subsetFeatures(GlobalPatterns, rowData(GlobalPatterns)$Phylum == "Actinobacteria" & 
               !is.na(rowData(GlobalPatterns)$Phylum))
               
}
