% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries.R
\name{summaries}
\alias{summaries}
\alias{getTopFeatures}
\alias{getTopTaxa}
\alias{getTopFeatures,SummarizedExperiment-method}
\alias{getTopTaxa,SummarizedExperiment-method}
\alias{getUniqueFeatures}
\alias{getUniqueTaxa}
\alias{getUniqueFeatures,SummarizedExperiment-method}
\alias{getUniqueTaxa,SummarizedExperiment-method}
\alias{countDominantFeatures}
\alias{countDominantFeatures,SummarizedExperiment-method}
\alias{countDominantTaxa}
\alias{countDominantTaxa,SummarizedExperiment-method}
\alias{summary,SummarizedExperiment-method}
\title{Summarizing microbiome data}
\usage{
getTopFeatures(
  x,
  top = 5L,
  method = c("mean", "sum", "median"),
  assay.type = assay_name,
  assay_name = "counts",
  na.rm = TRUE,
  ...
)

\S4method{getTopFeatures}{SummarizedExperiment}(
  x,
  top = 5L,
  method = c("mean", "sum", "median", "prevalence"),
  assay.type = assay_name,
  assay_name = "counts",
  na.rm = TRUE,
  ...
)

getTopTaxa(x, ...)

\S4method{getTopTaxa}{SummarizedExperiment}(x, ...)

getUniqueFeatures(x, ...)

\S4method{getUniqueFeatures}{SummarizedExperiment}(x, rank = NULL, ...)

getUniqueTaxa(x, ...)

\S4method{getUniqueTaxa}{SummarizedExperiment}(x, ...)

countDominantFeatures(x, group = NULL, name = "dominant_taxa", ...)

\S4method{countDominantFeatures}{SummarizedExperiment}(x, group = NULL, name = "dominant_taxa", ...)

countDominantTaxa(x, ...)

\S4method{countDominantTaxa}{SummarizedExperiment}(x, ...)

\S4method{summary}{SummarizedExperiment}(object, assay.type = assay_name, assay_name = "counts")
}
\arguments{
\item{x}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}} object.}

\item{top}{Numeric value, how many top taxa to return. Default return top
five taxa.}

\item{method}{Specify the method to determine top taxa. Either sum, mean,
median or prevalence. Default is 'mean'.}

\item{assay.type}{a \code{character} value to select an
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assayNames}}
By default it expects count data.}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{na.rm}{For \code{getTopFeatures} logical argument for calculation method
specified to argument \code{method}. Default is TRUE.}

\item{...}{Additional arguments passed on to \code{agglomerateByRank()} when
\code{rank} is specified for \code{countDominantFeatures}.}

\item{rank}{A single character defining a taxonomic rank. Must be a value of
the output of \code{taxonomyRanks()}.}

\item{group}{With group, it is possible to group the observations in an
overview. Must be one of the column names of \code{colData}.}

\item{name}{The column name for the features. The default is 'dominant_taxa'.}

\item{object}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}} object.}
}
\value{
The \code{getTopFeatures} returns a vector of the most \code{top} abundant
\dQuote{FeatureID}s

The \code{getUniqueFeatures} returns a vector of unique taxa present at a
particular rank

The \code{countDominantFeatures} returns an overview in a tibble. It contains dominant taxa
in a column named \code{*name*} and its abundance in the data set.

The \code{summary} returns a list with two \code{tibble}s
}
\description{
To query a \code{SummarizedExperiment} for interesting features, several
functions are available.
}
\details{
The \code{getTopFeatures} extracts the most \code{top} abundant \dQuote{FeatureID}s
in a \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.

The \code{getUniqueFeatures} is a basic function to access different taxa at a
particular taxonomic rank.

\code{countDominantFeatures} returns information about most dominant
taxa in a tibble. Information includes their absolute and relative
abundances in whole data set.

The \code{summary} will return a summary of counts for all samples and
features in
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.
}
\examples{
data(GlobalPatterns)
top_taxa <- getTopFeatures(GlobalPatterns,
                       method = "mean",
                       top = 5,
                       assay.type = "counts")
top_taxa

# Use 'detection' to select detection threshold when using prevalence method
top_taxa <- getTopFeatures(GlobalPatterns,
                       method = "prevalence",
                       top = 5,
                       assay_name = "counts",
                       detection = 100)
top_taxa
                       
# Top taxa os specific rank
getTopFeatures(agglomerateByRank(GlobalPatterns,
                             rank = "Genus",
                             na.rm = TRUE))

# Gets the overview of dominant taxa
dominant_taxa <- countDominantFeatures(GlobalPatterns,
                                   rank = "Genus")
dominant_taxa

# With group, it is possible to group observations based on specified groups
# Gets the overview of dominant taxa
dominant_taxa <- countDominantFeatures(GlobalPatterns,
                                   rank = "Genus",
                                   group = "SampleType",
                                   na.rm = TRUE)

dominant_taxa

# Get an overview of sample and taxa counts
summary(GlobalPatterns, assay_name= "counts")

# Get unique taxa at a particular taxonomic rank
# sort = TRUE means that output is sorted in alphabetical order
# With na.rm = TRUE, it is possible to remove NAs
# sort and na.rm can also be used in function getTopFeatures
getUniqueFeatures(GlobalPatterns, "Phylum", sort = TRUE)

}
\seealso{
\code{\link[=getPrevalence]{getPrevalentFeatures}}

\code{\link[scuttle:perCellQCMetrics]{perCellQCMetrics}},
\code{\link[scuttle:perFeatureQCMetrics]{perFeatureQCMetrics}},
\code{\link[scuttle:addPerCellQC]{addPerCellQC}},
\code{\link[scuttle:addPerFeatureQC]{addPerFeatureQC}},
\code{\link[scuttle:quickPerCellQC]{quickPerCellQC}}
}
\author{
Leo Lahti, Tuomas Borman and Sudarshan A. Shetty
}
