% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\docType{data}
\name{taxonomy-methods}
\alias{taxonomy-methods}
\alias{TAXONOMY_RANKS}
\alias{taxonomyRanks}
\alias{taxonomyRanks,SummarizedExperiment-method}
\alias{taxonomyRankEmpty}
\alias{taxonomyRankEmpty,SummarizedExperiment-method}
\alias{checkTaxonomy}
\alias{checkTaxonomy,SummarizedExperiment-method}
\alias{setTaxonomyRanks}
\alias{getTaxonomyRanks}
\alias{getTaxonomyLabels}
\alias{getTaxonomyLabels,SummarizedExperiment-method}
\alias{mapTaxonomy}
\alias{mapTaxonomy,SummarizedExperiment-method}
\alias{IdTaxaToDataFrame}
\title{Functions for accessing taxonomic data stored in \code{rowData}.}
\format{
a \code{character} vector of length 8 containing the taxonomy ranks
recognized. In functions this is used as case insensitive.
}
\usage{
TAXONOMY_RANKS

taxonomyRanks(x)

\S4method{taxonomyRanks}{SummarizedExperiment}(x)

taxonomyRankEmpty(
  x,
  rank = taxonomyRanks(x)[1L],
  empty.fields = c(NA, "", " ", "\\t", "-", "_")
)

\S4method{taxonomyRankEmpty}{SummarizedExperiment}(
  x,
  rank = taxonomyRanks(x)[1],
  empty.fields = c(NA, "", " ", "\\t", "-", "_")
)

checkTaxonomy(x, ...)

\S4method{checkTaxonomy}{SummarizedExperiment}(x)

setTaxonomyRanks(ranks)

getTaxonomyRanks()

getTaxonomyLabels(x, ...)

\S4method{getTaxonomyLabels}{SummarizedExperiment}(
  x,
  empty.fields = c(NA, "", " ", "\\t", "-", "_"),
  with_rank = FALSE,
  make_unique = TRUE,
  resolve_loops = FALSE,
  ...
)

mapTaxonomy(x, ...)

\S4method{mapTaxonomy}{SummarizedExperiment}(x, taxa = NULL, from = NULL, to = NULL, use_grepl = FALSE)

IdTaxaToDataFrame(from)
}
\arguments{
\item{x}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{rank}{a single character defining a taxonomic rank. Must be a value of
\code{taxonomyRanks()} function}

\item{empty.fields}{a \code{character} value defining, which values should be
regarded as empty. (Default: \code{c(NA, "", " ", "\t")}). They will be
removed if \code{na.rm = TRUE} before agglomeration}

\item{...}{optional arguments not used currently.}

\item{ranks}{Avector of ranks to be set}

\item{with_rank}{\code{TRUE} or \code{FALSE}: Should the level be add as a
suffix? For example: "Phylum:Crenarchaeota" (default:
\code{with_rank = FALSE})}

\item{make_unique}{\code{TRUE} or \code{FALSE}: Should the labels be made
unique, if there are any duplicates? (default: \code{make_unique = TRUE})}

\item{resolve_loops}{\code{TRUE} or \code{FALSE}: Should \code{resolveLoops}
be applied to the taxonomic data? Please note that has only an effect,
if the data is unique. (default: \code{resolve_loops = TRUE})}

\item{taxa}{a \code{character} vector, which is used for subsetting the
taxonomic information. If no information is found,\code{NULL} is returned
for the individual element. (default: \code{NULL})}

\item{from}{\itemize{
\item{For \code{mapTaxonomy}: }{a scalar \code{character} value, which
must be a valid taxonomic rank. (default: \code{NULL})}
\item{otherwise a \code{Taxa} object as returned by
\code{\link[DECIPHER:IdTaxa]{IdTaxa}}}
}}

\item{to}{a scalar \code{character} value, which must be a valid
taxonomic rank. (default: \code{NULL})}

\item{use_grepl}{\code{TRUE} or \code{FALSE}: should pattern matching via
\code{grepl} be used? Otherwise literal matching is used.
(default: \code{FALSE})}
}
\value{
\itemize{
\item{\code{taxonomyRanks}:} {a \code{character} vector with all the
taxonomic ranks found in \code{colnames(rowData(x))}}
\item{\code{taxonomyRankEmpty}:} {a \code{logical} value}
\item{\code{mapTaxonomy}:} {a \code{list} per element of taxa. Each
element is either a \code{DataFrame}, a \code{character} or \code{NULL}.
If all \code{character} results have the length of one, a single
\code{character} vector is returned.}
}
}
\description{
These function work on data present in \code{rowData} and define a way to
represent taxonomic data alongside the features of a
\code{SummarizedExperiment}.
}
\details{
\code{taxonomyRanks} returns, which columns of \code{rowData(x)} are regarded
as columns containing taxonomic information.

\code{taxonomyRankEmpty} checks, if a selected rank is empty of information.

\code{checkTaxonomy} checks, if taxonomy information is valid and whether
it contains any problems. This is a soft test, which reports some
diagnostic and might mature into a data validator used upon object
creation.

\code{getTaxonomyLabels} generates a character vector per row consisting of
the lowest taxonomic information possible. If data from different levels,
is to be mixed, the taxonomic level is prepended by default.

\code{IdTaxaToDataFrame} extracts taxonomic results from results of
\code{\link[DECIPHER:IdTaxa]{IdTaxa}}.

\code{mapTaxonomy} maps the given features (taxonomic groups; \code{taxa})
to the specified taxonomic level (\code{to} argument) in \code{rowData}
of the \code{SummarizedExperiment} data object
(i.e. \code{rowData(x)[,taxonomyRanks(x)]}). If the argument \code{to} is
not provided, then all matching taxonomy rows in \code{rowData} will be
returned. This function allows handy conversions between different

Taxonomic information from the \code{IdTaxa} function of \code{DECIPHER}
package are returned as a special class. With \code{as(taxa,"DataFrame")}
the information can be easily converted to a \code{DataFrame} compatible
with storing the taxonomic information a \code{rowData}. Please note that the
assigned confidence information are returned as \code{metatdata} and can
be accessed using \code{metadata(df)$confidence}.
}
\examples{
data(GlobalPatterns)
GlobalPatterns
taxonomyRanks(GlobalPatterns)

checkTaxonomy(GlobalPatterns)

table(taxonomyRankEmpty(GlobalPatterns,"Kingdom"))
table(taxonomyRankEmpty(GlobalPatterns,"Species"))

getTaxonomyLabels(GlobalPatterns[1:20,])

# mapTaxonomy
## returns the unique taxonomic information
mapTaxonomy(GlobalPatterns)
# returns specific unique taxonomic information
mapTaxonomy(GlobalPatterns, taxa = "Escherichia")
# returns information on a single output
mapTaxonomy(GlobalPatterns, taxa = "Escherichia",to="Family")

# setTaxonomyRanks
tse <- GlobalPatterns
colnames(rowData(tse))[1] <- "TAXA1"

setTaxonomyRanks(colnames(rowData(tse)))
# Taxonomy ranks set to: taxa1 phylum class order family genus species 

# getTaxonomyRanks is to get/check if the taxonomic ranks is set to "TAXA1"
getTaxonomyRanks()
}
\seealso{
\code{\link[=agglomerate-methods]{agglomerateByRank}},
\code{\link[TreeSummarizedExperiment:toTree]{toTree}},
\code{\link[TreeSummarizedExperiment:resolveLoop]{resolveLoop}}
}
\keyword{datasets}
