% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformCounts.R
\name{transformAssay}
\alias{transformAssay}
\alias{transformSamples}
\alias{transformSamples,SummarizedExperiment-method}
\alias{transformCounts}
\alias{transformAssay,SummarizedExperiment-method}
\alias{transformFeatures}
\alias{transformFeatures,SummarizedExperiment-method}
\alias{ZTransform}
\alias{ZTransform,SummarizedExperiment-method}
\alias{relAbundanceCounts}
\alias{relAbundanceCounts,SummarizedExperiment-method}
\title{Transform assay}
\usage{
transformSamples(
  x,
  assay.type = "counts",
  assay_name = NULL,
  method = c("alr", "chi.square", "clr", "frequency", "hellinger", "log", "log10",
    "log2", "normalize", "pa", "rank", "rclr", "relabundance", "rrank", "total"),
  name = method,
  ...
)

\S4method{transformSamples}{SummarizedExperiment}(
  x,
  assay.type = "counts",
  assay_name = NULL,
  method = c("alr", "chi.square", "clr", "frequency", "hellinger", "log", "log10",
    "log2", "normalize", "pa", "rank", "rclr", "relabundance", "rrank", "total"),
  name = method,
  pseudocount = FALSE,
  ...
)

transformAssay(
  x,
  assay.type = "counts",
  assay_name = NULL,
  method = c("alr", "chi.square", "clr", "frequency", "hellinger", "log", "log10",
    "log2", "max", "normalize", "pa", "range", "rank", "rclr", "relabundance", "rrank",
    "standardize", "total", "z"),
  MARGIN = "samples",
  name = method,
  pseudocount = FALSE,
  ...
)

transformCounts(x, ...)

\S4method{transformAssay}{SummarizedExperiment}(
  x,
  assay.type = "counts",
  assay_name = NULL,
  method = c("alr", "chi.square", "clr", "frequency", "hellinger", "log", "log10",
    "log2", "max", "normalize", "pa", "range", "rank", "rclr", "relabundance", "rrank",
    "standardize", "total", "z"),
  MARGIN = "samples",
  name = method,
  pseudocount = FALSE,
  ...
)

transformFeatures(
  x,
  assay.type = "counts",
  assay_name = NULL,
  method = c("frequency", "log", "log10", "log2", "max", "pa", "range", "standardize",
    "z"),
  name = method,
  pseudocount = FALSE,
  ...
)

\S4method{transformFeatures}{SummarizedExperiment}(
  x,
  assay.type = "counts",
  assay_name = NULL,
  method = c("frequency", "log", "log10", "log2", "max", "pa", "range", "standardize",
    "z"),
  name = method,
  pseudocount = FALSE,
  ...
)

ZTransform(x, MARGIN = "features", ...)

\S4method{ZTransform}{SummarizedExperiment}(x, MARGIN = "features", ...)

relAbundanceCounts(x, ...)

\S4method{relAbundanceCounts}{SummarizedExperiment}(x, ...)
}
\arguments{
\item{x}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{assay.type}{A single character value for selecting the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assay}} to be
transformed.}

\item{assay_name}{a single \code{character} value for specifying which
assay to use for calculation.
(Please use \code{assay.type} instead. At some point \code{assay_name}
will be disabled.)}

\item{method}{A single character value for selecting the transformation
method.}

\item{name}{A single character value specifying the name of transformed
abundance table.}

\item{...}{additional arguments passed on to \code{vegan:decostand}:
\itemize{
\item{\code{ref_vals}:} {A single value which will be used to fill
reference sample's column in returned assay when calculating alr.
(default: \code{ref_vals = NA})}
}}

\item{pseudocount}{TRUE, FALSE, or a numeric value. When TRUE,
automatically adds the minimum positive value of \code{assay.type}.
When FALSE, does not add any pseudocount (pseudocount = 0).
Alternatively, a user-specified numeric value can be added as pseudocount.}

\item{MARGIN}{A single character value for specifying whether the
transformation is applied sample (column) or feature (row) wise.
(By default: \code{MARGIN = "samples"})}
}
\value{
\code{transformAssay} returns the input object \code{x}, with a new
transformed abundance table named \code{name} added in the \code{\link{assay}}.
}
\description{
Variety of transformations for abundance data, stored in \code{assay}.
See details for options.
}
\details{
These \code{transformCount} function provides a variety of options for transforming abundance data.
The transformed data is calculated and stored in a new \code{assay}. The previously available
wrappers transformSamples, transformFeatures
ZTransform, and relAbundanceCounts have been deprecated.

The \code{transformAssay} provides sample-wise (column-wise) or feature-wise
(row-wise) transformation to the abundance table
(assay) based on specified \code{MARGIN}.

The available transformation methods include:

\itemize{

\item{'alr'}{ Additive log ratio (alr) transformation, please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'chi.square'}{ Chi square transformation, please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'clr'}{ Centered log ratio (clr) transformation, please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'frequency'}{ Frequency transformation, please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'hellinger'}{ Hellinger transformation, please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'log'}{ Logarithmic transformation, please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'log10'}{ log10 transformation can be used for reducing the skewness
of the data.
\deqn{log10 = \log_{10} x}{%
log10 = log10(x)}
where \eqn{x} is a single value of data.}

\item{'log2'}{ log2 transformation can be used for reducing the skewness of
the data.
\deqn{log2 = \log_{2} x}{%
log2 = log2(x)}
where \eqn{x} is a single value of data.}

\item{'normalize'}{ Make margin sum of squares equal to one. Please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'pa'}{ Transforms table to presence/absence table. Please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'rank'}{ Rank transformation, please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'rclr'}{ Robust clr transformation, please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'relabundance'}{ Relative transformation (alias for 'total'), please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'rrank'}{ Relative rank transformation, please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'standardize'}{ Scale 'x' to zero mean and unit variance (alias for
'z'), please refer to \code{\link[vegan:decostand]{decostand}} for details.}

\item{'total'}{ Divide by margin total (alias for
'relabundance'), please refer to
\code{\link[vegan:decostand]{decostand}} for details.}

\item{'z'}{ Z transformation (alias for 'standardize'),
please refer to \code{\link[vegan:decostand]{decostand}} for details.}

}
}
\examples{
data(esophagus, package="mia")
tse <- esophagus

# By specifying 'method', it is possible to apply different transformations, 
# e.g. compositional transformation.
tse <- transformAssay(tse, method = "relabundance")

# The target of transformation can be specified with "assay.type"
# Pseudocount can be added by specifying 'pseudocount'.

# Perform CLR with smallest positive value as pseudocount
tse <- transformAssay(tse, assay.type = "relabundance", method = "clr", 
                     pseudocount = TRUE
                     )
                      
head(assay(tse, "clr"))

# With MARGIN, you can specify the if transformation is done for samples or
# for features. Here Z-transformation is done feature-wise.
tse <- transformAssay(tse, method = "z", MARGIN = "features")
head(assay(tse, "z"))

# Name of the stored table can be specified.
tse <- transformAssay(tse, method="hellinger", name="test")
head(assay(tse, "test"))

# pa returns presence absence table.
tse <- transformAssay(tse, method = "pa")
head(assay(tse, "pa"))

# rank returns ranks of taxa.
tse <- transformAssay(tse, method = "rank")
head(assay(tse, "rank"))

# In order to use other ranking variants, modify the chosen assay directly:
assay(tse, "rank_average", withDimnames = FALSE) <- colRanks(assay(tse, "counts"), 
                                                           ties.method="average", 
                                                           preserveShape = TRUE)  

}
\author{
Leo Lahti and Tuomas Borman. Contact: \url{microbiome.github.io}
}
