% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view-composers.R
\name{remove_views}
\alias{remove_views}
\title{Remove views from the current view composition}
\usage{
remove_views(current.views, view.names)
}
\arguments{
\item{current.views}{the current view composition.}

\item{view.names}{the names of one or more views to be removed.}
}
\value{
A mistyR view composition with \code{view.names} views removed.
}
\description{
Remove one or more views from the view composition.
}
\details{
The intraview and the unique id cannot be removed with this function.
}
\examples{
library(dplyr)

# get the expression data
data("synthetic")
expr <- synthetic[[1]] \%>\% select(-c(row, col, type))
# get the coordinates for each cell
pos <- synthetic[[1]] \%>\% select(row, col)

# compose
misty.views <- create_initial_view(expr) \%>\%
  add_juxtaview(pos, neighbor.thr = 1.5) \%>\%
  add_paraview(pos, l = 10)

# preview
str(misty.views)

# remove juxtaview and preview
misty.views \%>\%
  remove_views("juxtaview.1.5") \%>\%
  str()

# remove juxtaview and paraview and preview
misty.views \%>\%
  remove_views(c("juxtaview.1.5", "paraview.10")) \%>\%
  str()
}
\seealso{
Other view composition functions: 
\code{\link{add_juxtaview}()},
\code{\link{add_paraview}()},
\code{\link{add_views}()},
\code{\link{create_initial_view}()},
\code{\link{create_view}()}
}
\concept{view composition functions}
