% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmgsa.R
\name{ggmgsa_multisplit}
\alias{ggmgsa_multisplit}
\title{Multi-split GGMGSA (parallelized computation)}
\usage{
ggmgsa_multisplit(x1, x2, b.splits = 50, gene.sets, gene.names,
  gs.names = NULL, method.p.adjust = "fdr",
  order.adj.agg = "agg-adj", mc.flag = FALSE, mc.set.seed = TRUE,
  mc.preschedule = TRUE, mc.cores = getOption("mc.cores", 2L),
  verbose = TRUE, ...)
}
\arguments{
\item{x1}{Expression matrix for condition 1 (mean zero is required).}

\item{x2}{Expression matrix for condition 2 (mean zero is required).}

\item{b.splits}{Number of random data splits (default=50).}

\item{gene.sets}{List of gene-sets.}

\item{gene.names}{Gene names. Each column in x1 (and x2) corresponds
to a gene.}

\item{gs.names}{Gene-set names (default=NULL).}

\item{method.p.adjust}{Method for p-value adjustment (default='fdr').}

\item{order.adj.agg}{Order of aggregation and adjustment of p-values.
Options: 'agg-adj' (default), 'adj-agg'.}

\item{mc.flag}{If \code{TRUE} use parallel execution for each b.splits via function 
\code{mclapply} of package \code{parallel}.}

\item{mc.set.seed}{See mclapply. Default=TRUE}

\item{mc.preschedule}{See mclapply. Default=TRUE}

\item{mc.cores}{Number of cores to use in parallel execution. Defaults to
mc.cores option if set, or 2 otherwise.}

\item{verbose}{If TRUE, show output progess.}

\item{...}{Other arguments (see diffnet_singlesplit).}
}
\value{
List consisting of
\item{medagg.pval}{Median aggregated p-values}
\item{meinshagg.pval}{Meinshausen aggregated p-values}
\item{pval}{matrix of p-values before correction and adjustement, dim(pval)=(number of gene-sets)x(number of splits)}
\item{teststatmed}{median aggregated test-statistic}
\item{teststatmed.bic}{median aggregated bic-corrected test-statistic}
\item{teststatmed.aic}{median aggregated aic-corrected test-statistic}
\item{teststat}{matrix of test-statistics, dim(teststat)=(number of gene-sets)x(number of splits)}
\item{rel.edgeinter}{normalized intersection of edges in condition 1 and 2}
\item{df1}{degrees of freedom of GGM obtained from condition 1}
\item{df2}{degrees of freedom of GGM obtained from condition 2}
\item{df12}{degrees of freedom of GGM obtained from pooled data (condition 1 and 2)}
}
\description{
Multi-split GGMGSA (parallelized computation)
}
\details{
Computation can be parallelized over many data splits.
}
\examples{
#######################################################
##This example illustrates the use of GGMGSA         ##
#######################################################


## Generate networks
set.seed(1)
p <- 9#network with p nodes
n <- 40
hub.net <- generate_2networks(p,graph='hub',n.hub=3,n.hub.diff=1)#generate hub networks
invcov1 <- hub.net[[1]]
invcov2 <- hub.net[[2]]
plot_2networks(invcov1,invcov2,label.pos=0,label.cex=0.7)

## Generate data
library('mvtnorm')
x1 <- rmvnorm(n,mean = rep(0,p), sigma = cov2cor(solve(invcov1)))
x2 <- rmvnorm(n,mean = rep(0,p), sigma = cov2cor(solve(invcov2)))

## Run DiffNet
# fit.dn <- diffnet_multisplit(x1,x2,b.splits=2,verbose=FALSE)
# fit.dn$medagg.pval

## Identify hubs with 'gene-sets'
gene.names <- paste('G',1:p,sep='')
gsets <- split(gene.names,rep(1:3,each=3))

## Run GGM-GSA
fit.ggmgsa <- ggmgsa_multisplit(x1,x2,b.splits=2,gsets,gene.names,verbose=FALSE)
summary(fit.ggmgsa)
fit.ggmgsa$medagg.pval#median aggregated p-values
p.adjust(apply(fit.ggmgsa$pval,1,median),method='fdr')#or: first median aggregation,
                                                      #second fdr-correction






}
\author{
n.stadler
}
