% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxfunc.R
\name{invcov2parcor_array}
\alias{invcov2parcor_array}
\title{Convert inverse covariance to partial correlation for several inverse
covariance matrices collected in an array.}
\usage{
invcov2parcor_array(invcov.array)
}
\arguments{
\item{invcov.array}{Array of inverse covariance matrices, of dimension
numNodes by numNodes by numComps.}
}
\value{
Array of partial correlation matrices of dimension numNodes by 
numNodes by numComps
}
\description{
Convert inverse covariance to partial correlation for several inverse
covariance matrices collected in an array.
}
\examples{
invcov.array = sapply(1:5, function(x) generate_inv_cov(p=25), simplify='array')
p.corr = invcov2parcor_array(invcov.array)
}
