% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netplot.R
\name{plot.nethetclustering}
\alias{plot.nethetclustering}
\title{Plot networks}
\usage{
\method{plot}{nethetclustering}(x,
  node.names = rownames(net.clustering$Mu),
  group.names = sort(unique(net.clustering$comp)),
  p.corrs.thresh = 0.2, print.pdf = FALSE, pdf.filename = "networks",
  ...)
}
\arguments{
\item{x}{A network clustering object as returned by 
\code{\link{screen_cv.glasso}} or \code{\link{mixglasso}}.}

\item{node.names}{Names for the nodes in the network. If NULL, names from 
net.clustering will be used.}

\item{group.names}{Names for the clusters or groups. If NULL, names from 
net.clustering will be used (by default these are integets 1:numClusters).}

\item{p.corrs.thresh}{Threshold applied to the absolute partial correlations. 
Edges that are below the threshold in all of the groups are not displayed.}

\item{print.pdf}{If TRUE, save the output as a PDF file.}

\item{pdf.filename}{If \code{print.pdf} is TRUE, specifies the file name of
the output PDF file.}

\item{...}{Further arguments}
}
\value{
Returns NULL and prints out the networks (or saves them to pdf if
\code{print.pdf} is TRUE. The networks are displayed as a series of nComps+1
plots, where in the first plot edge widths are shown according to 
the maximum partial correlation of the edge over all groups. The following plots
show the edges for each group. Positive partial correlation edges are shown in
black, negative ones in blue. If an edge is below the threshold on the absolute
partial correlation, it is displayed in gray or light blue respectively.
}
\description{
This function takes the output of \code{\link{screen_cv.glasso}} or 
\code{\link{mixglasso}} and creates a network plot using the network library.
}
