% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netplot.R
\name{scatter_plot}
\alias{scatter_plot}
\title{Create a scatterplot showing correlation between specific nodes in the network
for each pre-specified group.}
\usage{
scatter_plot(net.clustering, data, node.pairs, display = TRUE,
  node.names = rownames(net.clustering$Mu),
  group.names = sort(unique(net.clustering$comp)), cex = 1)
}
\arguments{
\item{net.clustering}{A network clustering object as returned by 
\code{\link{het_cv_glasso}} or \code{\link{mixglasso}}.}

\item{data}{Observed data for the nodes, a numObs by numNodes matrix. Note 
that nodes need to be in the same ordering as in node.names.}

\item{node.pairs}{A matrix of size numPairs by 2, where each row contains a 
pair of nodes to display. If node.names is specified, names in node.pairs
must correspond to elements of node.names.}

\item{display}{If TRUE, print the plot to the current output device.}

\item{node.names}{Names for the nodes in the network. If NULL, names from 
net.clustering will be used.}

\item{group.names}{Names for the clusters or groups. If NULL, names from 
net.clustering will be used (by default these are integets 1:numClusters).}

\item{cex}{Scale factor for text and symbols in plot.}
}
\value{
Returns a ggplot2 object. If display=TRUE, additionally displays the 
plot.
}
\description{
This function takes the output of \code{\link{het_cv_glasso}} or 
\code{\link{mixglasso}} and creates a plot showing the correlation between specified
node pairs in the network for all groups. The subplots for each node pair are 
arranged in a numPairs by numGroups grid. Partial correlations associated 
with each node pair are also displayed.
}
\examples{
n = 500
p = 10
s = 0.9
n.comp = 3

# Create different mean vectors
Mu = matrix(0,p,n.comp)

# Define non-zero means in each group (non-overlapping)
nonzero.mean = split(sample(1:p),rep(1:n.comp,length=p))

# Set non-zero means to fixed value
for(k in 1:n.comp){
	Mu[nonzero.mean[[k]],k] = -2/sqrt(ceiling(p/n.comp))
}

# Generate data
sim.result = sim_mix_networks(n, p, n.comp, s, Mu=Mu)
mixglasso.result = mixglasso(sim.result$data, n.comp=3)
mixglasso.clustering = mixglasso.result$models[[mixglasso.result$bic.opt]]

# Specify edges
node.pairs = rbind(c(1,3), c(6,9),c(7,8))

# Create scatter plots of specified edges
scatter_plot(mixglasso.clustering, data=sim.result$data,
					 node.pairs=node.pairs)
}
