% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netsim.R
\name{sim_mix_networks}
\alias{sim_mix_networks}
\title{sim_mix_networks}
\usage{
sim_mix_networks(n, p, n.comp, sparsity = 0.7, mix.prob = rep(1/n.comp,
  n.comp), Mu = NULL, Sig = NULL, ...)
}
\arguments{
\item{n}{Number of data points to simulate.}

\item{p}{Dimensionality of the data.}

\item{n.comp}{Number of components of the mixture model.}

\item{sparsity}{Determines the proportion of non-zero off-diagonal entries.}

\item{mix.prob}{Mixture probabilities for the components; defaults to 
uniform distribution.}

\item{Mu}{Means for the mixture components, a p by n.comp matrix. If NULL, 
sampled from a standard Gaussian.}

\item{Sig}{Covariances for the mixture components, a p by p by n.comp 
array. If NULL,
generated using \code{\link{generate_inv_cov}}.}

\item{...}{Further arguments passed to \code{\link{sim_mix}}.}
}
\value{
A list with components:
\code{Mu} Means of the mixture components.
\code{Sig} Covariances of the mixture components.
\code{data} Simulated data, a n by p matrix.
\code{S} Component assignments, a vector of length n.
}
\description{
Generate inverse covariances, means, mixing probabilities, and simulate 
data from resulting mixture model.
}
\details{
This function generates n.comp mean vectors from a standard Gaussian and
n.comp covariance matrices, with at most (1-sparsity)*p(p-1)/2
non-zero off-diagonal entries, where the non-zero entries are sampled from a 
beta distribution. Then it uses \code{\link{sim_mix}} to simulate from a 
mixture model with these means and covariance matrices.

Means Mu and covariance matrices Sig can also be supplied by the user.
}
\examples{
# Generate dataset with 100 samples of dimensionality 30, and 4 components
test.data = sim_mix_networks(n=100, p=30, n.comp=4)
}
