% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucleoSimFunctions.R
\name{syntheticNucReadsFromMap}
\alias{syntheticNucReadsFromMap}
\title{Generate a synthetic nucleosome map containing forward and
reverse reads}
\usage{
syntheticNucReadsFromMap(syntheticNucMap, read.len = 40, offset)
}
\arguments{
\item{syntheticNucMap}{a \code{list} of \code{class} "syntheticNucMap"}

\item{read.len}{a positive \code{integer}, the length of each of
the paired-end reads. Default = 40.}

\item{offset}{a non-negatvie \code{integer},the number of bases used to
offset all nucleosomes and reads.
This is done to ensure that all nucleosome positions and read alignments
are of positive values.}
}
\value{
a \code{list} of \code{class} "syntheticNucReads" containing the
following elements:
\itemize{
\item \code{call} the matched call.
\item \code{dataIP} a \code{data.frame} with the chromosome name, the
starting and ending positions and the direction of all forward
and reverse reads for all well-positioned and fuzzy nucleosomes.
Paired-end reads are identified with an unique id.
\item \code{wp} a \code{data.frame} with the positions of all the
well-positioned nucleosomes, as well as the number of paired-reads
associated to each one.
\item \code{fuz} a \code{data.frame} with the positions of all the fuzzy
nucleosomes, as well as the number of paired-reads associated to each one.
\item \code{paired} a \code{data.frame} with the starting and ending
positions of the reads used to generate the paired-end reads. Paired-end
reads are identified with an unique id.
}
}
\description{
Generate a synthetic nucleosome map using a synthetic
nucleosome map.

This function is using a modified version of the syntheticNucMap() function
from Bioconductor nucleR package (Flores and Orozco, 2011).
}
\examples{

## Generate a synthetic map with 20 well-positioned + 10 fuzzy nucleosomes
## using a Normal distribution with a variance of 30 for the well-positioned
## nucleosomes, a variance of 40 for the fuzzy nucleosomes and a seed of 15
## Because of the fixed seed, each time is going to be run, the results
## are going to be the seed
syntheticMap <- syntheticNucMapFromDist(wp.num = 20, wp.del = 0,
    wp.var = 30, fuz.num = 10, fuz.var = 40,
    rnd.seed = 335, as.ratio = FALSE, distr = "Uniform")

res <- nucleoSim:::syntheticNucReadsFromMap(syntheticMap, read.len = 45,
    offset = 1000)

}
\author{
Pascal Belleau, Rawane Samb, Astrid Deschenes
}
