% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\docType{methods}
\name{annotateRanges_great}
\alias{annotateRanges_great}
\alias{annotateRanges_great,profileplyr-method}
\title{Annotate profileplyr ranges to genes using rGREAT}
\usage{
annotateRanges_great(object = "profileplyr", species = "character", ...)

\S4method{annotateRanges_great}{profileplyr}(object = "profileplyr", species = "character", ...)
}
\arguments{
\item{object}{A profileplyr object}

\item{species}{GREAT accepts "hg19", "mm10", "mm9", "danRer7" (zebrafish)}

\item{...}{pass to \code{\link[rGREAT]{submitGreatJob}}}
}
\value{
A profileplyr object
}
\description{
The ranges from the deepTools matrix will be subset based on whether they overlap with specified annotated regions related to a user defined gene list.
}
\details{
tbd
}
\section{Methods (by class)}{
\itemize{
\item \code{annotateRanges_great(profileplyr)}: Annotate profileplyr ranges to genes using rGREAT

}}
\examples{
library(SummarizedExperiment)
example <- system.file("extdata", "example_deepTools_MAT", package = "profileplyr") 
object <- import_deepToolsMat(example)
object <- object[1:5, , ] 

# annotate ranges with genes using GREAT with following command:
annotateRanges_great(object, species = "mm10")

}
