% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\name{convertToEnrichedHeatmapMat}
\alias{convertToEnrichedHeatmapMat}
\alias{convertToEnrichedHeatmapMat,profileplyr-method}
\title{export a profileplyr object to a list of matrices that can be used as an input for EnrichedHeatmap}
\usage{
convertToEnrichedHeatmapMat(object = "profileplyr", sample_names = "character")

\S4method{convertToEnrichedHeatmapMat}{profileplyr}(object = "profileplyr", sample_names = NULL)
}
\arguments{
\item{object}{A profileplyr object}

\item{sample_names}{A character vector that will set the names of the heatmap components that are generated from the profileplyr assays() matrices. This argument is optional, by default the names will be the name of the samples in the profileplyr object rownames(sampleData(object)).}
}
\value{
A list of normalized matrices that can be used for generating visualizations with EnrichedHeatmap
}
\description{
export a profileplyr object to a list of matrices that can be used as an input for EnrichedHeatmap
}
\details{
Takes a profileplyr object and converts all of the matrices in the assays() section of the object to matrices that can be used as an input for EnrichedHeatmap
}
\section{Methods (by class)}{
\itemize{
\item \code{convertToEnrichedHeatmapMat(profileplyr)}: export a profileplyr object to a list of matrices that can be used as an input for EnrichedHeatmap

}}
\examples{

example <- system.file("extdata", "example_deepTools_MAT", package = "profileplyr") 
object <- import_deepToolsMat(example) 

library(EnrichedHeatmap)
EH_mat <- convertToEnrichedHeatmapMat(object)
EnrichedHeatmap(EH_mat[[1]], name = names(EH_mat[1]), column_title = names(EH_mat[1]))
}
