% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\docType{methods}
\name{export_deepToolsMat}
\alias{export_deepToolsMat}
\alias{export_deepToolsMat,profileplyr-method}
\alias{import_deepToolsMat}
\title{Export and import profileplyr from/to deeptools}
\usage{
export_deepToolsMat(
  object = "profileplyr",
  con = "character",
  decreasing = "logical",
  overwrite = "logical"
)

\S4method{export_deepToolsMat}{profileplyr}(
  object = "profileplyr",
  con = "character",
  decreasing = FALSE,
  overwrite = FALSE
)

import_deepToolsMat(con)
}
\arguments{
\item{object}{A profileplyr object}

\item{con}{Connection to write/read deeptools data to/from.}

\item{decreasing}{If object@params$mcolToOrderBy has been set and not NULL, then the ranges will be ordered by the column indicated in this slot of the metadata. By default, the order will be increasing for the factor or numeric value. For decreasing order, choose decreasing = TRUE.}

\item{overwrite}{Logical specifying whether to overwrite output if it exists.}
}
\value{
The path to deepTools matrix file

A profileplyr object
}
\description{
Export and Import files
}
\details{
A profileplyr object
}
\section{Methods (by class)}{
\itemize{
\item \code{export_deepToolsMat(profileplyr)}: Export and import profileplyr from/to deeptools

}}
\examples{

example <- system.file("extdata", "example_deepTools_MAT", package = "profileplyr") 
object <- import_deepToolsMat(example) 
export_deepToolsMat(object,file.path(tempdir(),"ATAC_Example.MAT"))
}
