% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\docType{methods}
\name{orderBy}
\alias{orderBy}
\alias{orderBy,profileplyr-method}
\title{choose the column by which to order the ranges by within each group}
\usage{
orderBy(object = "profileplyr", column = "ANY")

\S4method{orderBy}{profileplyr}(object = "profileplyr", column = "ANY")
}
\arguments{
\item{object}{A profileplyr object}

\item{column}{Which column of mcols(proplyrObject) should be used for ordering the ranges. If NULL removes any previous setting for row ordering.}
}
\value{
A profileplyr object
}
\description{
choose the column by which to order the ranges by within each group
}
\details{
Takes a profileplyr object and orders the rows based on a user defined metadata column of rowRanges
}
\section{Methods (by class)}{
\itemize{
\item \code{orderBy(profileplyr)}: choose the column by which to order the ranges by within each group

}}
\examples{
example <- system.file("extdata", "example_deepTools_MAT", package = "profileplyr") 
object <- import_deepToolsMat(example) 

library(SummarizedExperiment)
cluster <- clusterRanges(object, fun = rowMeans, cutree_rows = 3)
cluster_order <- orderBy(cluster, column = "hierarchical_order")
params(cluster_order)$mcolToOrderBy

}
