% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findProtease.R
\name{findProtease}
\alias{findProtease}
\title{Find Proteases}
\usage{
findProtease(protein, peptide, organism, start_pos, end_pos)
}
\arguments{
\item{protein}{a vector of UniProt Accession IDs.}

\item{peptide}{a vector of amino acid sequences corresponding to the
proteins.}

\item{organism}{name of organism.}

\item{start_pos}{(optional) numeric vector of N-terminus positions in
protein sequence.}

\item{end_pos}{(optional) numeric vector of C-terminus positions in
protein sequence.}
}
\value{
S4 object Cleavages
}
\description{
Given a vector of peptides and proteins,
finds known proteases acting on cleavage sites.
}
\examples{
protein <- c("P02671", "P02671", "P68871", "P01011")
peptide <- c("FEEVSGNVSPGTR", "FVSETESR", "LLVVYPW", "ITLLSAL")
res <- findProtease(protein = protein,
                    peptide = peptide,
                    organism = "Homo sapiens")

}
