% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchProtease.R
\name{searchProtease}
\alias{searchProtease}
\title{Show Cleaving Data for a Peptidase or Inhibitor by Uniprot accession}
\usage{
searchProtease(protein, organism = "Homo sapiens", summarize = FALSE)
}
\arguments{
\item{protein}{a vector of corresponding UniProt Accession IDs.}

\item{organism}{name of organism.}

\item{summarize}{if false (default), provides a detailed table of all
associated cleaving events, otherwise outputs a summarized table and only
includes reviewed (Uniprot) entries.}
}
\value{
data.table, character
}
\description{
Given a vector of proteins, finds which substrates they cleave.
}
\examples{
protein <- c("P98073", "P00734")
searchProtease(protein = protein)

}
