% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{gds_idatquery}
\alias{gds_idatquery}
\title{Query and download IDATs from GEO Data Sets}
\usage{
gds_idatquery(
  gsmvi,
  ext = "gz",
  expand = TRUE,
  verbose = FALSE,
  dfp = "idats",
  burl = paste0("ftp://ftp.ncbi.nlm.nih.gov/geo/samples/")
)
}
\arguments{
\item{gsmvi}{Vector of valid GSM IDs.}

\item{ext}{Filename extension.}

\item{expand}{Whether to expand compressed files.}

\item{verbose}{Whether to show verbose messages (default FALSE).}

\item{dfp}{Destination directory for downloads.}

\item{burl}{Base URL string for RCurl query.}
}
\value{
Lists the basename paths and filenames of IDATs downloaded.
}
\description{
Queries GEO Data Sets for IDATs, and downloads available IDATs. This uses 
anticipated string pattern to construct the URL path for the query. 
IDATs are detected from the supplement for a GSE record.
}
\examples{
query <- try(gds_idatquery(gsmvi = c("GSM2465267", "GSM2814572")))
}
