% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{getrg}
\alias{getrg}
\title{Query and store data from h5 file signal tables}
\usage{
getrg(
  dbn,
  gsmv = NULL,
  cgv = NULL,
  data.type = c("se"),
  dsv = c("redsignal", "greensignal"),
  all.gsm = FALSE,
  all.cg = TRUE,
  metadata = TRUE,
  md.dsn = "mdpost",
  verbose = FALSE
)
}
\arguments{
\item{dbn}{Name of the HDF5 database file.}

\item{gsmv}{Vector valid GSM IDs (rows) to query, 
either NULL or vector of length > 2 valid GSM IDs, 
or "all.gsm" should be TRUE.}

\item{cgv}{Vector of valid bead addresses (columns) to query
in the signal datasets (default NULL).}

\item{data.type}{Format for returned query matches, either as 
datasets "df" or RGChannelSet "se" object.}

\item{dsv}{Vector of raw signal datasets or group paths to query, 
including both the red channel 'redsignal' and green channel 
'greensignal' datasets.}

\item{all.gsm}{Whether to query all available GSM IDs.}

\item{all.cg}{Whether to query all available CpG probe addresses.}

\item{metadata}{Whether to access available postprocessed 
metadata for queried samples.}

\item{md.dsn}{Name of metadata dataset in h5 file.}

\item{verbose}{Whether to post status messages.}
}
\value{
Returns either an RGChannelSet or list of data.frame objects 
 from dataset query matches.
}
\description{
Queries signal datasets in an h5 HDF5 database file. 
Handles identity queries to rows (GSM IDs) or columns 
(bead addresses). Returns query matches either 
as a list of datasets or a single RGChannelSet, with 
option to include sample metadata.
}
\examples{
path <- system.file("extdata", "h5test", package = "recountmethylation")
fn <- list.files(path)
dbpath <- file.path(path, fn)
rg <- getrg(dbn = dbpath, all.gsm = TRUE, metadata = FALSE)
dim(rg) # [1] 11162     2
class(rg)
# [1] "RGChannelSet"
# attr(,"package")
# [1] "minfi"
}
\seealso{
rgse()
}
