% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{hread}
\alias{hread}
\title{Query and store an HDF5 dataset on row and column indices.}
\usage{
hread(ri, ci, dsn = "redsignal", dbn = "remethdb2.h5")
}
\arguments{
\item{ri}{Row indices in dataset.}

\item{ci}{Column indices in dataset.}

\item{dsn}{Name of dataset or group of dataset to connect with.}

\item{dbn}{Path to h5 database file.}
}
\value{
HDF5 database connection object.
}
\description{
Connect to an HDF5 database h5 file with rhdf5::h5read(). 
Returns the subsetted data.
}
\examples{
# Get tests data pointer
path <- system.file("extdata", "h5test", package = "recountmethylation")
fn <- list.files(path)
dbpath <- file.path(path, fn)
# red signal, first 2 assay addr, 3 samples
reds <- hread(1:2, 1:3, d = "redsignal", dbn = dbpath)
dim(reds) # [1] 2 3
}
