% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnam_search_index.R
\name{make_si}
\alias{make_si}
\title{make_si}
\usage{
make_si(
  fh_csv_fpath,
  si_fname = "new_search_index.pickle",
  si_dict_fname = "new_index_dict.pickle",
  threads = 4,
  space_val = "l2",
  efc_val = 2000,
  m_val = 1000,
  ef_val = 2000
)
}
\arguments{
\item{fh_csv_fpath}{Name/path of csv (e.g. a table of hashed features) 
containing data for the index (required, string, "bvaltest.csv", where 
rows = samples, cols = features).}

\item{si_fname}{Name of new search index file to save (required, string, 
"new_search_index.pickle")}

\item{si_dict_fname}{Name of new index dictionary, with string labels, to 
save (required, string, "new_index_dict.pickle").}

\item{threads}{Number of threads for processing new index (required, int, 4).}

\item{space_val}{Space value for new search index (required, valid string, 
l2').}

\item{efc_val}{EFC value for the index (required, int, 2000).}

\item{m_val}{M value for the index (required, int, 1000).}

\item{ef_val}{EF value for the index (required, int, 2000).}
}
\value{
Boolean, TRUE if new search index and dictionary created, FALSE if 
creating the new search index and dictionary files failed, otherwise NULL.
}
\description{
Make search index from table of hashed features. Additional details about 
the hnswlib search index parameters (e..g `space_val`, `efc_val`, `m_val`, 
and `ef_val`) can be found in the Python package docstrings and ReadMe.
}
\examples{
# fh_csv_fpath <- system.file("extdata", "fhtest", 
# package = "recountmethylation")
# fh_csv_fpath <- file.path(fh_csv_fpath, "bval_fn.csv")
# make_si(fh_csv_fpath)
}
