% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_db.R
\name{servermatrix}
\alias{servermatrix}
\title{servermatrix}
\usage{
servermatrix(
  dn = NULL,
  sslver = FALSE,
  printmatrix = TRUE,
  url = "https://methylation.recount.bio/",
  verbose = FALSE
)
}
\arguments{
\item{dn}{Server data returned from RCurl (default NULL).}

\item{sslver}{Whether to use SSL certificate authentication for server 
connection (default FALSE).}

\item{printmatrix}{Whether to print the data matrix to console (default 
TRUE).}

\item{url}{Server website url (default "https://methylation.recount.bio/").}

\item{verbose}{Whether to show verbose messages (default FALSE).}
}
\value{
Matrix of server files and file metadata
}
\description{
Called by get_rmdl() to get a matrix of database files and file info from 
the server. Verifies valid versions and timestamps in filenames, and that 
h5se directories contain both an assays and an se.rds file.
}
\examples{
dn <- "remethdb-h5se_gr-test_0-0-1_1590090412 29-May-2020 07:28 -"
sm <- get_servermatrix(dn = dn)
}
\seealso{
get_rmdl, smfilt
}
