% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opls-methods.R
\name{residuals}
\alias{residuals}
\alias{residuals.opls}
\alias{residuals,opls-method}
\title{Residuals method for (O)PLS models}
\usage{
residuals(object, ...)
}
\arguments{
\item{object}{An S4 object of class \code{opls}, created by \code{opls}
function.}

\item{...}{Currently not used.}
}
\value{
Numeric matrix or vector (same dimensions as the modeled y
response); if y is a character vector or a factor (in case of
classification), the residuals equal 0 (predicted class identical to the
true class) or 1 (prediction error)
}
\description{
Returns the residuals from the (O)PLS(-DA) regression models
}
\examples{

data(sacurine)
attach(sacurine)

sacurine.pls <- opls(dataMatrix,
                     sampleMetadata[, "age"])

head(residuals(sacurine.pls))

detach(sacurine)

}
\author{
Etienne Thevenot, \email{etienne.thevenot@cea.fr}
}
