% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{heatmapSignPlot}
\alias{heatmapSignPlot}
\title{Global Heatmap of Signatures' scores.}
\usage{
heatmapSignPlot(
  data,
  whichSign = NULL,
  clusterBySign = NULL,
  sampleAnnot = NULL,
  signAnnot = NULL,
  splitBySampleAnnot = FALSE,
  ...
)
}
\arguments{
\item{data}{an object of type \linkS4class{SummarizedExperiment}. Output of
the signatures functions.}

\item{whichSign}{character vector saying the signatures to plot. If not
specified, all the signatures inside data will be plotted. Other signatures
not computed with signifinder can be added in the vector if they are also
included in che colData section of data.}

\item{clusterBySign}{character vector saying one or more signatures to use to
cluster columns.}

\item{sampleAnnot}{vector containing samples' annotations.}

\item{signAnnot}{character vector of signature's annotations. One or more
between: "signature", "topic", "tumor", "tissue".}

\item{splitBySampleAnnot}{logical. If TRUE it splits columns by samples'
annotations.}

\item{...}{other parameters specific of the function
\code{\link[ComplexHeatmap]{Heatmap}}.}
}
\value{
A \code{\link[ComplexHeatmap]{Heatmap-class}} object.
}
\description{
Given one or multiple signatures, the function returns a heatmap of scores.
Since each signature has its own method to compute the score then to plot
several signatures together the scores are transformed into z-score,
individually for each signature.
}
\examples{
data(ovse)
heatmapSignPlot(data = ovse)

}
