###
###

.genome <- "GRCh37.p13"

.onLoad <- function(libname, pkgname)
{
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make Seqinfo object.
    seqinfo_path <- file.path(extdata_dirpath, "seqinfo.txt")
    seqtable <- read.table(seqinfo_path, stringsAsFactors=FALSE)
    seqnames <- seqtable[[1L]]
    seqinfo <- Seqinfo(
        seqnames=seqnames,
        seqlengths=seqtable[[2L]],
        isCircular=seqtable[[3L]],
        genome=.genome
    )

    ## Make GenomeDescription object. See
    ##   http://www.ncbi.nlm.nih.gov/assembly/GCF_000001405.25/
    ## for more information about GRCh37.p13.
    reference_genome <- GenomeDescription(
        organism="Homo sapiens",
        common_name="Human",
        provider="NCBI",
        provider_version=.genome,
        release_date="2013-06-28",
        release_name="GRCh37 Patch Release 13",
        seqinfo=seqinfo
    )

    ## Make and export XtraSNPlocs object.
    xtra_snps <- newXtraSNPlocs(
        pkgname,
        extdata_dirpath,
        provider="dbSNP",
        provider_version="dbSNP Human BUILD 144",
        release_date="June 2015",
        release_name="dbSNP Human BUILD 144",
        download_url="ftp://ftp.ncbi.nih.gov/snp/organisms/human_9606_b144_GRCh37p13/ASN1_flat/",
        download_date="July 2, 2015",
        reference_genome=reference_genome
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, xtra_snps, envir=ns)
    namespaceExport(ns, objname)
}

