\name{agARACYCENZYME}
\alias{agARACYCENZYME}
\title{Map between Manufacturer IDs and Enzyme Names from ARACYC}
\description{ 
  agARACYCENZYME is an R object that provides mappings between
  manufacturer identifiers and Enzyme Names from ARACYC. 
}
\details{
  Each manufacturer identifier maps to a named vector containing the
  Enzyme name for that gene according to the ARACYC database.  If this
  information is unknown, the vector will contain an \code{NA}.
    
  Mappings between probe identifiers and enzyme identifiers were obtained 
  using files provided by: Tair  
  ftp://ftp.plantcyc.org/Pathways/Data\_dumps/PMN15\_January2021/pathways/ara\_pathways.20210325.txt  
  With a date stamp from the source of: 2021-Apr15
}

\seealso{
  \itemize{
    \item \code{\link[AnnotationDbi]{AnnotationDb-class}} for use of
          the \code{select()} interface.
  }
}

\examples{
## select() interface:
## Objects in this package can be accessed using the select() interface 
## from the AnnotationDbi package. See ?select for details.

## Bimap interface:
x <- agARACYCENZYME
# Get the probe identifiers that are mapped to an Enzyme Name 
mapped_probes <- mappedkeys(x)
# Convert to a list
xx <- as.list(x[mapped_probes])
if(length(xx) > 0) {
  # Get the ENZYME name for the first five probes
  xx[1:5]
  # Get the first one
  xx[[1]]
}
}
\keyword{datasets}

