datacache <- new.env(hash=TRUE, parent=emptyenv())

illuminaHumanv2 <- function() {
cat("####Mappings based on RefSeqID####\n")
showQCData("illuminaHumanv2", datacache)
cat("####Custom Mappings based on probe sequence####\n")
illuminaHumanv2listNewMappings()

}

illuminaHumanv2_dbconn <- function() dbconn(datacache)
illuminaHumanv2_dbfile <- function() dbfile(datacache)
illuminaHumanv2_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaHumanv2_dbInfo <- function() dbInfo(datacache)

illuminaHumanv2ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaHumanv2.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "illuminaHumanv2", "chip illuminaHumanv2", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaHumanv2.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaHumanv2_dbconn())
}

##Custom Bimaps for the package

illuminaHumanv2ARRAYADDRESS <- createSimpleBimap("ExtraInfo", "IlluminaID","ArrayAddress", datacache, "ARRAYADDRESS","illuminaHumanv2.db")

illuminaHumanv2NUID <- createSimpleBimap("ExtraInfo", "IlluminaID","NuID", datacache, "NUID","illuminaHumanv2.db")

illuminaHumanv2PROBEQUALITY <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeQuality", datacache, "PROBEQUALITY","illuminaHumanv2.db")

illuminaHumanv2CODINGZONE <- createSimpleBimap("ExtraInfo", "IlluminaID","CodingZone", datacache, "CODINGZONE","illuminaHumanv2.db")

illuminaHumanv2PROBESEQUENCE <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeSequence", datacache, "PROBESEQUENCE","illuminaHumanv2.db")

illuminaHumanv2SECONDMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","SecondMatches", datacache, "SECONDMATCHES","illuminaHumanv2.db")

illuminaHumanv2OTHERGENOMICMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","OtherGenomicMatches", datacache, "OTHERGENOMICMATCHES","illuminaHumanv2.db")

illuminaHumanv2REPEATMASK <- createSimpleBimap("ExtraInfo", "IlluminaID","RepeatMask", datacache, "REPEATMASK","illuminaHumanv2.db")

illuminaHumanv2OVERLAPPINGSNP <- createSimpleBimap("ExtraInfo", "IlluminaID","OverlappingSNP", datacache, "OVERLAPPINGSNP","illuminaHumanv2.db")

illuminaHumanv2ENTREZREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EntrezReannotated", datacache, "ENTREZREANNOTATED","illuminaHumanv2.db")

illuminaHumanv2GENOMICLOCATION <- createSimpleBimap("ExtraInfo", "IlluminaID","GenomicLocation", datacache, "GENOMICLOCATION","illuminaHumanv2.db")

illuminaHumanv2SYMBOLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","SymbolReannotated", datacache, "SYMBOLREANNOTATED","illuminaHumanv2.db")

illuminaHumanv2REPORTERGROUPNAME <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupName", datacache, "REPORTERGROUPNAME","illuminaHumanv2.db")

illuminaHumanv2REPORTERGROUPID <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupID", datacache, "REPORTERGROUPID","illuminaHumanv2.db")

illuminaHumanv2ENSEMBLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EnsemblReannotated", datacache, "ENSEMBLREANNOTATED","illuminaHumanv2.db")

illuminaHumanv2listNewMappings = function(){
cat("illuminaHumanv2ARRAYADDRESS()\n") 
cat("illuminaHumanv2NUID()\n") 
cat("illuminaHumanv2PROBEQUALITY()\n") 
cat("illuminaHumanv2CODINGZONE()\n") 
cat("illuminaHumanv2PROBESEQUENCE()\n") 
cat("illuminaHumanv2SECONDMATCHES()\n") 
cat("illuminaHumanv2OTHERGENOMICMATCHES()\n") 
cat("illuminaHumanv2REPEATMASK()\n") 
cat("illuminaHumanv2OVERLAPPINGSNP()\n") 
cat("illuminaHumanv2ENTREZREANNOTATED()\n") 
cat("illuminaHumanv2GENOMICLOCATION()\n") 
cat("illuminaHumanv2SYMBOLREANNOTATED()\n") 
cat("illuminaHumanv2REPORTERGROUPNAME()\n") 
cat("illuminaHumanv2REPORTERGROUPID()\n") 
cat("illuminaHumanv2ENSEMBLREANNOTATED()\n") 
}
illuminaHumanv2fullReannotation = function(){
dbGetQuery(illuminaHumanv2_dbconn(), "SELECT * FROM ExtraInfo")
}
