% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRInference-class.R,
%   R/BSRInferenceComp-class.R
\name{reduceToLigand}
\alias{reduceToLigand}
\alias{reduceToLigand,BSRInference-method}
\alias{reduceToLigand,BSRInferenceComp-method}
\title{Aggregate the receptors of a same ligand}
\usage{
\S4method{reduceToLigand}{BSRInference}(obj)

\S4method{reduceToLigand}{BSRInferenceComp}(obj)
}
\arguments{
\item{obj}{BSRInferenceComp object}
}
\value{
A BSRInference object but reduced to one row per ligand.
All the receptors are combined in a
semi-colon-separated list surrounded by curly brackets in the tabular
slot \code{LRinter}, and in vectors in the \code{ligands} (list) slot.

The reported P-value and target genes are those from the pathway with
the smallest P-value.

A BSRInferenceComp object but reduced to one row per ligand.
All the receptors are combined in a
semi-colon-separated list surrounded by curly brackets in the tabular
slot \code{LRinter}, and in vectors in the \code{ligands} (list) slot.

The reported P-value and target genes are those from the pathway with
the smallest P-value.
The same logic applies to the LR-score, and the receptor
expression.
}
\description{
Simplifies a ligand-receptor table to focus on the ligands.

Simplifies a ligand-receptor table to focus on the ligands.
}
\examples{
data(bsrinf, package = "BulkSignalR")

bsrinf.redL <- reduceToLigand(bsrinf)

data(bsrinf.comp, package = "BulkSignalR")

bsrinf.redL <- reduceToLigand(bsrinf.comp)
}
