% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRInference-class.R,
%   R/BSRInferenceComp-class.R
\name{reduceToReceptor}
\alias{reduceToReceptor}
\alias{reduceToReceptor,BSRInference-method}
\alias{reduceToReceptor,BSRInferenceComp-method}
\title{Aggregate the ligands of a same receptor}
\usage{
\S4method{reduceToReceptor}{BSRInference}(obj)

\S4method{reduceToReceptor}{BSRInferenceComp}(obj)
}
\arguments{
\item{obj}{BRSInferenceComp object}
}
\value{
BSRInference object reduced to one row per receptor.
All the ligands are combined in a
semi-colon-separated list surrounded by curly brackets in the tabular
slot \code{LRinter}, and in vectors in the \code{ligands} (list) slot.

The reported P-value and target genes are those from the line with the
pathway featuring the smallest P-value.

BSRInferenceComp object reduced to one row per receptor.
All the ligands are combined in a
semi-colon-separated list surrounded by curly brackets in the tabular
slot \code{LRinter}, and in vectors in the \code{ligands} (list) slot.

The reported P-value and target genes are those from the line with the
pathway featuring the smallest P-value.
The same logic applies to the LR-score, and the ligand
expression.
}
\description{
Simplifies a ligand-receptor table to focus on the receptors.

Simplifies a ligand-receptor table to focus on the receptors.
}
\examples{
data(bsrinf, package = "BulkSignalR")

bsrinf.redR <- reduceToReceptor(bsrinf)

data(bsrinf.comp, package = "BulkSignalR")
# reduction
bsrinf.redR <- reduceToReceptor(bsrinf.comp)
}
