% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_records_class.R
\name{combine_records}
\alias{combine_records}
\title{Combine annotation records (rows)}
\usage{
combine_records(
  group_by,
  default_fcn = fuse(separator = " || "),
  fcns = list(),
  ...
)
}
\arguments{
\item{group_by}{(character) The column used as the key for grouping
records.}

\item{default_fcn}{(function) The default function to use for
summarising columns when combining records and a specific function
has not been provided in fcns. The default is \code{fuse(separator =
" || ")}.}

\item{fcns}{(list) A named list of functions to use for summarising
named columns when combining records. Names should correspond to the
columns in the annotation table. The default is \code{list()}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{combine_records} object with the following
\code{output} slots:
\tabular{ll}{
\code{updated} \tab (annotation_source) The input annotation source
with the newly generated column. \cr
}
}
\description{
Combine annotation records (rows) based on a key. All
records with the same key will be combined. A number of helper
functions are provided for common approaches to merging records.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{dplyr}}}
}
\section{Inheritance}{

A \code{combine_records} object inherits the following \code{struct} classes:
\cr\cr
\verb{[combine_records]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- combine_records(
        fcns = list(),
        group_by = character(0),
        default_fcn = function(){})

}
\references{
Wickham H, François R, Henry L, Müller K, Vaughan D
(2023). \emph{dplyr: A Grammar of Data Manipulation}. R package version
1.1.4, \url{https://CRAN.R-project.org/package=dplyr}.

Lloyd GR, Jankevics A, Weber RJM (2020). "struct: an
R/Bioconductor-based framework for standardized metabolomics data
analysis and beyond." \emph{Bioinformatics}, \emph{36}(22-23), 5551-5552.
}
