% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_file_class.R
\name{github_file}
\alias{github_file}
\title{GitHub file}
\usage{
github_file(
  username,
  repository_name,
  file_path,
  bfc_path = NULL,
  resource_name = paste(username, repository_name, file_path, sep = "_"),
  ...
)
}
\arguments{
\item{username}{(character) The GitHub username to retireve the file
from.}

\item{repository_name}{(character) The name of a repository for the
specified GitHub usernamethat contains the file to download.}

\item{file_path}{(character) The path to the file to download within
the specified GitHub repository.}

\item{bfc_path}{(character, NULL) \code{BiocFileCache} is used to cache
the database locally and prevent unnecessary downloads. If a path is
provided then \code{BiocFileCache} will use this location. If NULL it will
use the default location (see \code{\link[BiocFileCache:BiocFileCache-class]{BiocFileCache::BiocFileCache()}} for
details). The default is \code{NULL}.}

\item{resource_name}{(character) The name given to this resource in
the cache. (see \code{\link[BiocFileCache:BiocFileCache-class]{BiocFileCache::BiocFileCache()}} for details). The
default is \code{paste(username, repository_name, file_path, sep =
"_")}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
github_file
} object. This object has no \code{output} slots.
}
\description{
Uses the GitHub REST API to retrieve a file from a
specifiedGitHub repository.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{BiocFileCache}} \item{\code{httr}}}
}
\section{Inheritance}{

A \code{github_file} object inherits the following \code{struct} classes:
\cr\cr
\verb{[github_file]} -> \verb{[BiocFileCache_database]} ->
\verb{[annotation_database]} -> \verb{[annotation_source]} -> \verb{[struct_class]}
}

\examples{
M <- github_file(
        username = character(0),
        repository_name = character(0),
        file_path = character(0),
        bfc_path = NULL,
        resource_name = "bfc",
        bfc_fun = function(){},
        import_fun = function(){},
        offline = FALSE,
        tag = character(0),
        data = data.frame(),
        source = "ANY")

}
\references{
Shepherd L, Morgan M (2024). \emph{BiocFileCache: Manage Files
Across Sessions}. doi:10.18129/B9.bioc.BiocFileCache
\url{https://doi.org/10.18129/B9.bioc.BiocFileCache}, R package version
2.14.0, \url{https://bioconductor.org/packages/BiocFileCache}.

Wickham H (2023). \emph{httr: Tools for Working with URLs and
HTTP}. R package version 1.4.7,
\url{https://CRAN.R-project.org/package=httr}.
}
