% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise_strings_class.R
\name{normalise_strings}
\alias{normalise_strings}
\title{Normalise string}
\usage{
normalise_strings(
  search_column,
  output_column = NULL,
  dictionary = list(),
  ...
)
}
\arguments{
\item{search_column}{(character) The column name of the input
\code{annotation_source} that will be searched for matching (sub)strings.}

\item{output_column}{(character, NULL) The name of a new column that
the modified strings will be stored in. If NULL the \code{search_column}
will be replaced. The default is \code{NULL}.}

\item{dictionary}{(list, annotation_database) A list of patterns and
functions that take the input pattern and return a replacement
string. A \code{annotation_database} object containing a suitable list can
also be used here. The default is \code{list()}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{normalise_strings} object with the following
\code{output} slots:
\tabular{ll}{
\code{updated} \tab (annotation_source) The updated annotations as an
\code{annotation_source} object. \cr
}
}
\description{
Replace matching (sub)strings based on a provided
dictionary of search terms and their replacements.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{dplyr}}}

Each item of the \code{dictionary} list should #' have at least two
fields: "pattern" and "replace". "pattern" is used as
inputs to the \verb{[grepl()]} function to detect matches to the input pattern.
Parameters such as \code{perl = TRUE} can also be included in the list and these
will be passed to \verb{[grepl()]}, otherwise the defaults are used.
When a match is detected the function in "replace" is called with the same
inputs as \verb{[grepl()]}. The "replace" function should return a new string.
Alternatively \code{replace = NA} can be used to return NA for a matching pattern.
If a character string is provided then \verb{[gsub()]} will be used by default.
}
\section{Inheritance}{

A \code{normalise_strings} object inherits the following \code{struct} classes:
\cr\cr
\verb{[normalise_strings]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- normalise_strings(
        search_column = character(0),
        output_column = NULL,
        dictionary = list())

}
\references{
Wickham H, François R, Henry L, Müller K, Vaughan D
(2023). \emph{dplyr: A Grammar of Data Manipulation}. R package version
1.1.4, \url{https://CRAN.R-project.org/package=dplyr}.
}
\seealso{
\code{\link[=grepl]{grepl()}}, \code{\link[=gsub]{gsub()}}
}
