% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importPeaks.R
\name{importPeaks}
\alias{importPeaks}
\title{Import peaks}
\usage{
importPeaks(
  x,
  type = c("narrow", "broad", "bed"),
  blacklist,
  seqinfo,
  pruning.mode = c("coarse", "error"),
  sort = TRUE,
  setNames = TRUE,
  glueNames = "{basename(x)}",
  centre = FALSE,
  nameRanges = TRUE,
  ...
)
}
\arguments{
\item{x}{One or more files to be imported. All files must be of the same
type, i.e. narrow or broad}

\item{type}{The type of peaks to be imported}

\item{blacklist}{A set of ranges to be excluded}

\item{seqinfo}{A seqinfo object to be applied to the GRanges objects}

\item{pruning.mode}{How to handle conflicts if supplying a seqinfo object.
Defaults to \code{pruning.mode = "coarse"}. Only "coarse" and "error" are
implemented. See \link[GenomeInfoDb]{seqinfo}.}

\item{sort}{logical. Should the ranges be sorted during import}

\item{setNames}{logical Set basename(x) as the name for each element of the
GRangesList}

\item{glueNames}{\link[glue]{glue} syntax for naming list elements}

\item{centre}{Add the estimated peak centre. Ignored unless type = "narrow"}

\item{nameRanges}{Place any values in the name column as range names within
each file.}

\item{...}{passed to \code{sort}}
}
\value{
A GRangesList
}
\description{
Import peaks in narrowPeak, broadPeak or bed format
}
\details{
Peaks are imported from narrowPeak, broadPeak or bed format as
GenomicRanges objects.

If importing bed files, only the default 3-6 columns will imported.
}
\examples{
fl <- system.file(
    c("extdata/ER_1.narrowPeak", "extdata/ER_2.narrowPeak"),
    package = "extraChIPs"
)
peaks <- importPeaks(fl)
peaks

}
