% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{create_multiassay}
\alias{create_multiassay}
\title{MultiAssayExperiment generation}
\usage{
create_multiassay(
  methylation = NULL,
  cnv_data = NULL,
  gene_exp = NULL,
  miRNA_exp = NULL,
  miRNA_cnv_data = NULL,
  ...
)
}
\arguments{
\item{methylation}{Matrix or SummarizedExperiment for Methylation data}

\item{cnv_data}{Matrix or SummarizedExperiment for genes' Copy Number
Variation data}

\item{gene_exp}{Matrix or SummarizedExperiment for Gene expression data}

\item{miRNA_exp}{Matrix or SummarizedExperiment for miRNA expression data}

\item{miRNA_cnv_data}{Matrix or SummarizedExperiment for miRNA's Copy
Number Variations data}

\item{...}{Additional arguments to be passed to the function}
}
\value{
A MultiAssayExperiment object containing the provided assays.
}
\description{
This function will generate a proper MultiAssayExperiment suitable for the
\strong{run_multiomics} function.
}
\examples{
# Example usage:
library(MultiAssayExperiment)
data('mmultiassay_ov')
gene_exp_matrix <- as.matrix(assay(mmultiassay_ov[['gene_exp']]))
miRNA_exp_matrix <- as.matrix(assay(mmultiassay_ov[['miRNA_exp']]))
meth_matrix <- as.matrix(assay(mmultiassay_ov[['methylation']]))
gene_cnv_matrix <- as.matrix(assay(mmultiassay_ov[['cnv_data']]))
miRNA_cnv_matrix <- as.matrix(assay(mmultiassay_ov[['miRNA_cnv_data']]))
create_multiassay(methylation=meth_matrix, cnv_data=gene_cnv_matrix,
 gene_exp=gene_exp_matrix, miRNA_exp=miRNA_exp_matrix,
 miRNA_cnv_data=miRNA_cnv_matrix)
}
