% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allgenerics.R, R/helper_functions.R
\name{extract_model_res}
\alias{extract_model_res}
\alias{extract_model_res,list-method}
\alias{extract_model_res,MultiClass-method}
\alias{extract_model_res,MultiOmics-method}
\title{Setting method for extracting results}
\usage{
extract_model_res(model_results, ...)

\S4method{extract_model_res}{list}(
  model_results,
  outliers = TRUE,
  species = "hsa",
  filters = c("hgnc_symbol", "ensembl_gene_id", "entrezgene_id"),
  genes_info = NULL,
  ...
)

\S4method{extract_model_res}{MultiClass}(
  model_results,
  outliers = TRUE,
  species = "hsa",
  filters = c("hgnc_symbol", "ensembl_gene_id", "entrezgene_id"),
  genes_info = NULL,
  ...
)

\S4method{extract_model_res}{MultiOmics}(
  model_results,
  outliers = TRUE,
  species = "hsa",
  filters = c("hgnc_symbol", "ensembl_gene_id", "entrezgene_id"),
  genes_info = NULL,
  ...
)
}
\arguments{
\item{model_results}{The model results object from which to extract results.}

\item{...}{Additional arguments to be passed to specific methods.}

\item{outliers}{if TRUE (by default), it removes outliers}

\item{species}{species for the analysis}

\item{filters}{Specific filters to apply}

\item{genes_info}{genes info}
}
\value{
A dataframe containing the results of all the integration models
provided
}
\description{
Setting method for extracting results
}
\examples{
# example code
library(MultiAssayExperiment)
data("mmultiassay_ov")
tmp <- lapply(experiments(mmultiassay_ov), function(x) x[1:20,])
mmultiassay_ov <- MultiAssayExperiment(experiments = tmp)
gene_cnv_matrix <- t(as.matrix(assay(mmultiassay_ov[["cnv_data"]])))
gene_exp_matrix <- t(as.matrix(assay(mmultiassay_ov[["gene_exp"]])))
cnv_integration <- run_cnv_integration(
    expression = gene_exp_matrix,
    cnv_data = gene_cnv_matrix
)
data_table <- extract_model_res(cnv_integration)
head(data_table)
}
