% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscFunctions.R
\name{distinctColors}
\alias{distinctColors}
\title{Generate a distinct palette for coloring different clusters}
\usage{
distinctColors(
  n,
  hues = c("red", "cyan", "orange", "blue", "yellow", "purple", "green", "magenta"),
  saturation.range = c(0.7, 1),
  value.range = c(0.7, 1)
)
}
\arguments{
\item{n}{Integer; Number of colors to generate}

\item{hues}{Character vector of R colors available from the colors()
function. These will be used as the base colors for the clustering scheme.
Different saturations and values (i.e. darkness) will be generated for each
hue.}

\item{saturation.range}{Numeric vector of length 2 with values between 0 and
1. Default: c(0.25, 1)}

\item{value.range}{Numeric vector of length 2 with values between 0 and 1.
Default: c(0.5, 1)}
}
\value{
A vector of distinct colors that have been converted to  HEX from
HSV.
}
\description{
Generate a distinct palette for coloring different clusters
}
\examples{
distinctColors(10)
}
