% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importGeneSets.R
\name{importGeneSetsFromList}
\alias{importGeneSetsFromList}
\title{Imports gene sets from a list}
\usage{
importGeneSetsFromList(
  inSCE,
  geneSetList,
  collectionName = "GeneSetCollection",
  by = "rownames",
  noMatchError = TRUE
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{geneSetList}{Named List. A list containing one or more gene sets.
Each element of the list should be a character vector of gene identifiers.
The names of the list will be become the gene set names in the
\linkS4class{GeneSetCollection} object.}

\item{collectionName}{Character. Name of collection to add gene sets to.
If this collection already exists in \code{inSCE}, then these gene sets will
be added to that collection. Any gene sets within the collection with the
same name will be overwritten. Default \code{GeneSetCollection}.}

\item{by}{Character or character vector. Describes the
location within \code{inSCE} where the gene identifiers in
\code{geneSetList} should be mapped. If set to \code{"rownames"} then the
features will be searched for among \code{rownames(inSCE)}. This can also be
set to one of the column names of \code{rowData(inSCE)} in which case the
gene identifies will be mapped to that column in the \code{rowData}
of \code{inSCE}. Finally, \code{by} can be a vector the same length as
the number of gene sets in \code{geneSetList} and the elements of the vector
can point to different locations within \code{inSCE}. See
\link{featureIndex} for more information.
Default \code{"rownames"}.}

\item{noMatchError}{Boolean. Show an error if a collection does not have
any matching features. Default \code{TRUE}.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object
with gene set from \code{collectionName} output stored to the
\link{metadata} slot.
}
\description{
Converts a list of gene sets into a
\linkS4class{GeneSetCollection} and stores it in the metadata of the
\linkS4class{SingleCellExperiment} object. These gene sets can be used in
downstream quality control and analysis functions in \link{singleCellTK}.
}
\details{
The gene identifiers in gene sets in \code{geneSetList} will be
mapped to the rownames of \code{inSCE} using the \code{by} parameter and
stored in a \linkS4class{GeneSetCollection} object from package
\link{GSEABase}. This object is stored in
\code{metadata(inSCE)$sctk$genesets}, which can be accessed in downstream
analysis functions such as \link[singleCellTK]{runCellQC}.
}
\examples{
data(scExample)

# Generate gene sets from 'rownames'
gs1 <- rownames(sce)[seq(10)]
gs2 <- rownames(sce)[seq(11,20)]
gs <- list("geneset1" = gs1, "geneset2" = gs2)
sce <- importGeneSetsFromList(inSCE = sce,
                              geneSetList = gs,
                              by = "rownames")

# Generate a gene set for mitochondrial genes using
# Gene Symbols stored in 'rowData'
mito.ix <- grep("^MT-", rowData(sce)$feature_name)
mito <- list(mito = rowData(sce)$feature_name[mito.ix])
sce <- importGeneSetsFromList(inSCE = sce,
                             geneSetList = mito,
                             by = "feature_name")
}
\seealso{
\link{importGeneSetsFromCollection} for importing from
\linkS4class{GeneSetCollection} objects,
\link{importGeneSetsFromGMT} for importing from GMT files, and
\link{importGeneSetsFromMSigDB} for importing MSigDB gene sets.
}
\author{
Joshua D. Campbell
}
