% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFindMarkerHeatmap.R
\name{plotFindMarkerHeatmap}
\alias{plotFindMarkerHeatmap}
\alias{plotMarkerDiffExp}
\title{Plot a heatmap to visualize the result of \code{\link{runFindMarker}}}
\usage{
plotFindMarkerHeatmap(
  inSCE,
  orderBy = "size",
  log2fcThreshold = 1,
  fdrThreshold = 0.05,
  minClustExprPerc = 0.7,
  maxCtrlExprPerc = 0.4,
  minMeanExpr = 1,
  topN = 10,
  decreasing = TRUE,
  rowLabel = TRUE,
  rowDataName = NULL,
  colDataName = NULL,
  featureAnnotations = NULL,
  cellAnnotations = NULL,
  featureAnnotationColor = NULL,
  cellAnnotationColor = NULL,
  colSplitBy = NULL,
  rowSplitBy = "marker",
  rowDend = FALSE,
  colDend = FALSE,
  title = "Top Marker Heatmap",
  ...
)

plotMarkerDiffExp(
  inSCE,
  orderBy = "size",
  log2fcThreshold = 1,
  fdrThreshold = 0.05,
  minClustExprPerc = 0.7,
  maxCtrlExprPerc = 0.4,
  minMeanExpr = 1,
  topN = 10,
  decreasing = TRUE,
  rowDataName = NULL,
  colDataName = NULL,
  featureAnnotations = NULL,
  cellAnnotations = NULL,
  featureAnnotationColor = NULL,
  cellAnnotationColor = NULL,
  colSplitBy = NULL,
  rowSplitBy = "marker",
  rowDend = FALSE,
  colDend = FALSE,
  title = "Top Marker Heatmap",
  ...
)
}
\arguments{
\item{inSCE}{\linkS4class{SingleCellExperiment} inherited object.}

\item{orderBy}{The ordering method of the clusters on the splitted heatmap.
Can be chosen from \code{"size"} or \code{"name"}, specified with vector of
ordered unique cluster labels, or set as \code{NULL} for unsplitted heatmap.
Default \code{"size"}.}

\item{log2fcThreshold}{Only use DEGs with the absolute values of log2FC
larger than this value. Default \code{1}}

\item{fdrThreshold}{Only use DEGs with FDR value smaller than this value.
Default \code{0.05}}

\item{minClustExprPerc}{A numeric scalar. The minimum cutoff of the
percentage of cells in the cluster of interests that expressed the marker
gene. Default \code{0.7}.}

\item{maxCtrlExprPerc}{A numeric scalar. The maximum cutoff of the
percentage of cells out of the cluster (control group) that expressed the
marker gene. Default \code{0.4}.}

\item{minMeanExpr}{A numeric scalar. The minimum cutoff of the mean
expression value of the marker in the cluster of interests. Default \code{1}.}

\item{topN}{An integer. Only to plot this number of top markers for each
cluster in maximum, in terms of log2FC value. Use \code{NULL} to cancel the
top N subscription. Default \code{10}.}

\item{decreasing}{Order the cluster decreasingly. Default \code{TRUE}.}

\item{rowLabel}{\code{TRUE} for displaying \code{rownames} of \code{inSCE}, a
\code{rowData} variable to use other feature identifiers, or a vector for
customized row labels. Use \code{FALSE} for not displaying. Default
\code{TRUE}.}

\item{rowDataName}{character. The column name(s) in \code{rowData} that need
to be added to the annotation. Default \code{NULL}.}

\item{colDataName}{character. The column name(s) in \code{colData} that need
to be added to the annotation. Default \code{NULL}.}

\item{featureAnnotations}{\code{data.frame}, with \code{rownames} containing
all the features going to be plotted. Character columns should be factors.
Default \code{NULL}.}

\item{cellAnnotations}{\code{data.frame}, with \code{rownames} containing
all the cells going to be plotted. Character columns should be factors.
Default \code{NULL}.}

\item{featureAnnotationColor}{A named list. Customized color settings for
feature labeling. Should match the entries in the \code{featureAnnotations}
or \code{rowDataName}. For each entry, there should be a list/vector of
colors named with categories. Default \code{NULL}.}

\item{cellAnnotationColor}{A named list. Customized color settings for
cell labeling. Should match the entries in the \code{cellAnnotations} or
\code{colDataName}. For each entry, there should be a list/vector of colors
named with categories. Default \code{NULL}.}

\item{colSplitBy}{character vector. Do semi-heatmap based on the grouping of
this(these) annotation(s). Should exist in either \code{colDataName} or
\code{names(cellAnnotations)}. Default is the value of \code{cluster} in
\code{\link{runFindMarker}} when \code{orderBy} is not \code{NULL}, or
\code{NULL} otherwise.}

\item{rowSplitBy}{character vector. Do semi-heatmap based on the grouping of
this(these) annotation(s). Should exist in either \code{rowDataName} or
\code{names(featureAnnotations)}. Default \code{"marker"}, which indicates an
auto generated annotation for this plot.}

\item{rowDend}{Whether to display row dendrogram. Default \code{FALSE}.}

\item{colDend}{Whether to display column dendrogram. Default \code{FALSE}.}

\item{title}{Text of the title, at the top of the heatmap. Default
\code{"Top Marker Heatmap"}.}

\item{...}{Other arguments passed to \code{\link{plotSCEHeatmap}}.}
}
\value{
A \code{\link[ComplexHeatmap]{Heatmap}} object
}
\description{
This function will first reads the result saved in
\code{metadata} slot, named by \code{"findMarker"} and generated by
\code{\link{runFindMarker}}. Then it do the filtering on the statistics
based on the input parameters and get unique genes to plot. We choose the
genes that are identified as up-regulated only. As for the genes identified
as up-regulated for multiple clusters, we only keep the belonging towards the
one they have the highest Log2FC value.
In the heatmap, there will always be a cell annotation for the cluster
labeling used when finding the markers, and a feature annotation for which
cluster each gene belongs to. And by default we split the heatmap by these
two annotations. Additional legends can be added and the splitting can be
canceled.
}
\examples{
data("sceBatches")
logcounts(sceBatches) <- log1p(counts(sceBatches))
sce.w <- subsetSCECols(sceBatches, colData = "batch == 'w'")
sce.w <- runFindMarker(sce.w, method = "wilcox", cluster = "cell_type")
plotFindMarkerHeatmap(sce.w)
}
\seealso{
\code{\link{runFindMarker}}, \code{\link{getFindMarkerTopTable}}
}
\author{
Yichen Wang
}
