% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlReports.R
\name{reportCellQC}
\alias{reportCellQC}
\title{Get runCellQC .html report}
\usage{
reportCellQC(
  inSCE,
  output_file = NULL,
  output_dir = NULL,
  subTitle = NULL,
  studyDesign = NULL,
  useReducedDim = NULL
)
}
\arguments{
\item{inSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object containing
the filtered count matrix with the output from runCellQC function}

\item{output_file}{Character. The name of the generated file. If NULL/default then the output file name will be based on the name of the Rmarkdown template.}

\item{output_dir}{Character. The name of the output directory to save the rendered file. If NULL/default the file is stored to the current working directory}

\item{subTitle}{subtitle of the QC HTML report. Default is NULL.}

\item{studyDesign}{Character. The description of the data set and experiment design. It would be shown at the top of QC HTML report. Default is NULL.}

\item{useReducedDim}{Character. The name of the saved dimension reduction slot including cells
from all samples in then\linkS4class{SingleCellExperiment} object, Default is NULL}
}
\value{
.html file
}
\description{
A  function to generate .html Rmarkdown report containing the visualizations of the runCellQC function output
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
\dontrun{
sce <- runCellQC(sce)
reportCellQC(inSCE = sce)
}
}
