/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.awt.geom.Point2D;

public class Zoom {
    public Point2D[] setZoom(Point2D[] pontos, double flip, double focoX, double focoY, double fator) {
        for (int i = 0; i < pontos.length; ++i) {
            double x = pontos[i].getX();
            double y = pontos[i].getY();
            double distance = Math.abs(focoY - y);
            double zoom_y = distance * fator;
            y = y < focoY ? (y += flip * zoom_y) : (y -= flip * zoom_y);
            distance = Math.abs(focoX - x);
            double zoom_x = distance * fator;
            x = x < focoX ? (x += flip * zoom_x) : (x -= flip * zoom_x);
            pontos[i].setLocation(x, y);
        }
        return pontos;
    }

    public Point2D[] resetZoom(Point2D[] pontos, double zoomInOut, double focoX, double focoY) {
        double fator = 1.0 - 1.0 / zoomInOut;
        for (int i = 0; i < pontos.length; ++i) {
            double x = pontos[i].getX();
            double y = pontos[i].getY();
            double distance = Math.abs(focoY - y);
            double zoom_y = distance * fator;
            y = y < focoY ? (y += zoom_y) : (y -= zoom_y);
            distance = Math.abs(focoX - x);
            double zoom_x = distance * fator;
            x = x < focoX ? (x += zoom_x) : (x -= zoom_x);
            pontos[i].setLocation(x, y);
        }
        return pontos;
    }

    public Point2D[] setCenter(Point2D[] pontos, double focoX, double focoY) {
        double xMax = 0.0;
        double yMax = 0.0;
        double xMin = 1.0E8;
        double yMin = 1.0E8;
        for (int i = 0; i < pontos.length; ++i) {
            double x = pontos[i].getX();
            double y = pontos[i].getY();
            if (x > xMax) {
                xMax = x;
            }
            if (y > yMax) {
                yMax = y;
            }
            if (x < xMin) {
                xMin = x;
            }
            if (!(y < yMin)) continue;
            yMin = y;
        }
        double centroX = xMin + (xMax - xMin) / 2.0;
        double centroY = yMin + (yMax - yMin) / 2.0;
        double deltaX = focoX - centroX;
        double deltaY = focoY - centroY;
        for (int i = 0; i < pontos.length; ++i) {
            double x = pontos[i].getX() + deltaX;
            double y = pontos[i].getY() + deltaY;
            pontos[i].setLocation(x, y);
        }
        return pontos;
    }
}

