/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.GFFRecordFilter;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class GFFEntrySet {
    private List lines = new ArrayList();

    public void add(String string) {
        this.lines.add(string);
    }

    public void add(GFFRecord gFFRecord) {
        this.lines.add(gFFRecord);
    }

    public GFFEntrySet filter(GFFRecordFilter gFFRecordFilter) {
        GFFEntrySet gFFEntrySet = new GFFEntrySet();
        Iterator iterator = this.lineIterator();
        while (iterator.hasNext()) {
            GFFRecord gFFRecord;
            Object e = iterator.next();
            if (!(e instanceof GFFRecord) || !gFFRecordFilter.accept(gFFRecord = (GFFRecord)e)) continue;
            gFFEntrySet.add(gFFRecord);
        }
        return gFFEntrySet;
    }

    public GFFDocumentHandler getAddHandler() {
        return new EntrySetBuilder();
    }

    public SequenceAnnotator getAnnotator() {
        return new SequenceAnnotator(){

            public Sequence annotate(Sequence sequence) throws BioException, ChangeVetoException {
                Feature.Template template = new Feature.Template();
                StrandedFeature.Template template2 = new StrandedFeature.Template();
                template.annotation = Annotation.EMPTY_ANNOTATION;
                template2.annotation = Annotation.EMPTY_ANNOTATION;
                Iterator iterator = GFFEntrySet.this.lineIterator();
                while (iterator.hasNext()) {
                    GFFRecord gFFRecord;
                    Object e = iterator.next();
                    if (!(e instanceof GFFRecord) || !(gFFRecord = (GFFRecord)e).getSeqName().equals(sequence.getName())) continue;
                    if (gFFRecord.getStrand() == StrandedFeature.UNKNOWN) {
                        template.location = new RangeLocation(gFFRecord.getStart(), gFFRecord.getEnd());
                        template.type = gFFRecord.getFeature();
                        template.source = gFFRecord.getSource();
                        sequence.createFeature(template);
                        continue;
                    }
                    template2.location = new RangeLocation(gFFRecord.getStart(), gFFRecord.getEnd());
                    template2.type = gFFRecord.getFeature();
                    template2.source = gFFRecord.getSource();
                    template2.strand = gFFRecord.getStrand();
                    sequence.createFeature(template2);
                }
                return sequence;
            }
        };
    }

    public Iterator lineIterator() {
        return this.lines.iterator();
    }

    public int size() {
        return this.lines.size();
    }

    private class EntrySetBuilder
    implements GFFDocumentHandler {
        EntrySetBuilder() {
        }

        public void commentLine(String string) {
            GFFEntrySet.this.lines.add(string);
        }

        public void endDocument() {
        }

        public void recordLine(GFFRecord gFFRecord) {
            GFFEntrySet.this.lines.add(gFFRecord);
        }

        public void startDocument(String string) {
        }
    }
}

