% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{results}
\alias{results,ABSDataSet-method}
\alias{results}
\title{Accessor functions for the result from a ABSDataSet}
\usage{
\S4method{results}{ABSDataSet}(object, cnames = c("Amean", "Bmean",
  "baseMean", "absD", "Variance", "rawFC", "lowFC", "foldChange", "pvalue",
  "adj.pvalue", "trimmed"))
}
\arguments{
\item{object}{a ABSDataSet}

\item{cnames}{a vecotr of names for output, which are among:
'Amean','Bmean', log2 of mean counts for group A and B,
"baseMean', estimated mean for absolute counts difference (absD), used for mu in \code{\link{pnbinom}}
'absD', absolute counts difference in total
'Variance', pooled Variance for two groups
'rawFC','lowFC', 'foldChange', log2 fold-change of original (Bmean-Amean), corrected by expression level and corrected by both expression level and gene-specific dispersion
'pvalue','adj.pvalue', pvalue and adjusted pvalue
'trimmed', number of trimmed outliers}
}
\value{
a table according to canmes.
}
\description{
Accessor functions for the result from a ABSDataSet by given names
}
\details{
This function returns the result of ABSSeq as a table or a vector depended on
the given names, see \code{\link{ABSSeq}}
}
\examples{
data(simuN5)
obj <- ABSDataSet(counts=simuN5$counts, groups=factor(simuN5$groups))
obj <- normalFactors(obj)
obj <- callParameter(obj)
obj <- callDEs(obj)
head(results(obj))
}
\seealso{
\code{\link{ABSSeq}}
}

