% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wrap.R
\name{EvaluateMethods}
\alias{EvaluateMethods}
\title{Imputation method evaluation on training set}
\usage{
EvaluateMethods(data, sce = NULL, do = c('Baseline', 'DrImpute',
'Network'), write = FALSE, train.ratio = .7, train.only = TRUE,
mask.ratio = .1, outdir = getwd(), scale = 1, pseudo.count = 1,
labels = NULL, cell.clusters = 2, drop_thre = NULL, type = 'count',
cores = BiocParallel::bpworkers(BPPARAM),
BPPARAM = BiocParallel::SnowParam(type = "SOCK"),
net.coef = ADImpute::network.coefficients, net.implementation = 'iteration',
tr.length = ADImpute::transcript_length, bulk = NULL, ...)
}
\arguments{
\item{data}{matrix; normalized counts, not logged (genes as rows and samples
as columns)}

\item{sce}{SingleCellExperiment; normalized counts and associated metadata.}

\item{do}{character; choice of methods to be used for imputation. Currently
supported methods are \code{'Baseline'}, \code{'DrImpute'} and
\code{'Network'}. Not case-sensitive. Can include one or more methods. Non-
supported methods will be ignored.}

\item{write}{logical; write intermediary and imputed objects to files?}

\item{train.ratio}{numeric; ratio of samples to be used for training}

\item{train.only}{logical; if TRUE define only a training dataset, if
FALSE writes and returns both training and validation sets (defaults to TRUE)}

\item{mask.ratio}{numeric; ratio of samples to be masked per gene}

\item{outdir}{character; path to directory where output files are written.
Defaults to working directory}

\item{scale}{integer; scaling factor to divide all expression levels by
(defaults to 1)}

\item{pseudo.count}{integer; pseudo-count to be added to expression levels
to avoid log(0) (defaults to 1)}

\item{labels}{character; vector specifying the cell type of each column of
\code{data}}

\item{cell.clusters}{integer; number of cell subpopulations}

\item{drop_thre}{numeric; between 0 and 1 specifying the threshold to
determine dropout values}

\item{type}{A character specifying the type of values in the expression
matrix. Can be 'count' or 'TPM'}

\item{cores}{integer; number of cores used for paralell computation}

\item{BPPARAM}{parallel back-end to be used during parallel computation.
See \code{\link[BiocParallel]{BiocParallelParam-class}}.}

\item{net.coef}{matrix; network coefficients. Please provide if you don't
want to use ADImpute's network model. Must contain one first column 'O'
acconting for the intercept of the model and otherwise be an adjacency matrix
with hgnc_symbols in rows and columns. Doesn't have to be squared. See
\code{ADImpute::demo_net} for a small example.}

\item{net.implementation}{character; either 'iteration', for an iterative
solution, or 'pseudoinv', to use Moore-Penrose pseudo-inversion as a
solution. 'pseudoinv' is not advised for big data.}

\item{tr.length}{matrix with at least 2 columns: 'hgnc_symbol' and
'transcript_length'}

\item{bulk}{vector of reference bulk RNA-seq, if available (average across
samples)}

\item{...}{additional parameters to pass to network-based imputation}
}
\value{
\itemize{
    \item if \code{sce} is provided: returns a SingleCellExperiment with the
    best performing method per gene stored as row-features. Access via
    \code{SingleCellExperiment::int_elementMetadata(sce)$ADImpute$methods}.
    \item if \code{sce} is not provided: returns a character with the best
    performing method in the training set for each gene
}
}
\description{
\code{EvaluateMethods} returns the best-performing imputation
method for each gene in the dataset
}
\details{
For each gene, a fraction (\code{mask.ratio}) of the quantified
expression values are set to zero and imputed according to 3 different
methods: scImpute, baseline (average gene expression across all cells) or a
network-based method. The imputation error is computed for each of the
values in the original dataset that was set to 0, for each method. The
method resulting in a lowest imputation error for each gene is chosen.
}
\examples{
# Normalize demo data
norm_data <- NormalizeRPM(ADImpute::demo_data)
method_choice <- EvaluateMethods(norm_data, do = c('Baseline','DrImpute'),
cores = 2)

}
\seealso{
\code{\link{ImputeBaseline}},
\code{\link{ImputeDrImpute}},
\code{\link{ImputeNetwork}}
}
