% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiologicalZeros.R
\name{GetDropoutProbabilities}
\alias{GetDropoutProbabilities}
\title{Get dropout probabilities}
\usage{
GetDropoutProbabilities(data, thre, cell.clusters, labels = NULL,
type = 'count', cores, BPPARAM, genelen = ADImpute::transcript_length)
}
\arguments{
\item{data}{matrix; original data before imputation}

\item{thre}{numeric; probability threshold to classify entries as biological
zeros}

\item{cell.clusters}{integer; number of cell subpopulations}

\item{labels}{character; vector specifying the cell type of each column of
\code{data}}

\item{type}{A character specifying the type of values in the expression
matrix. Can be 'count' or 'TPM'}

\item{cores}{integer; number of cores used for paralell computation}

\item{BPPARAM}{parallel back-end to be used during parallel computation.
See \code{\link[BiocParallel]{BiocParallelParam-class}}.}

\item{genelen}{matrix with at least 2 columns: 'hgnc_symbol' and
'transcript_length'}
}
\value{
matrix with same dimensions as \code{data} containing the dropout
probabilities for the corresponding entries
}
\description{
\code{GetDropoutProbabilities} computes dropout probabilities
(probability of being a dropout that should be imputed rather than a true
biological zero) using an adaptation of scImpute's approach
}
\details{
This function follows scImpute's model to distinguish between
true biological zeros and dropouts, and is based on adapted code from the
scImpute R package.
}
