% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiologicalZeros.R
\name{HandleBiologicalZeros}
\alias{HandleBiologicalZeros}
\title{Get dropout probabilities}
\usage{
HandleBiologicalZeros(data, imputed, thre = 0.5, cell.clusters,
labels = NULL, type = 'count', cores = BiocParallel::bpworkers(BPPARAM),
BPPARAM = BiocParallel::SnowParam(type = "SOCK"),
genelen = ADImpute::transcript_length, prob.mat = NULL)
}
\arguments{
\item{data}{matrix; original data before imputation}

\item{imputed}{list; imputation results for considered methods}

\item{thre}{numeric; between 0 and 1 specifying the threshold to determine
dropout values}

\item{cell.clusters}{integer; number of cell subpopulations}

\item{labels}{character; vector specifying the cell type of each column of
\code{data}}

\item{type}{A character specifying the type of values in the expression
matrix. Can be 'count' or 'TPM'}

\item{cores}{integer; number of cores used for paralell computation}

\item{BPPARAM}{parallel back-end to be used during parallel computation.
See \code{\link[BiocParallel]{BiocParallelParam-class}}.}

\item{genelen}{matrix with at least 2 columns: 'hgnc_symbol' and
'transcript_length'}

\item{prob.mat}{matrix with same dimensions as \code{data} containing the
dropout probabilities for the corresponding entries}
}
\value{
list with 2 components: \code{zerofiltered}, a list equivalent to
\code{imputed} but with entries of imputed likely biological zeros set back
to zero, and \code{dropoutprobabilities}
matrix with same dimensions as \code{data} containing the dropout
probabilities for the corresponding entries
}
\description{
\code{GetDropoutProbabilities} computes dropout probabilities
(probability of being a dropout that should be imputed rather than a true
biological zero) using an adaptation of scImpute's approach
}
\details{
This function follows scImpute's model to distinguish between
true biological zeros and dropouts, and is based on adapted code from the
scImpute R package.
}
