% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clr_ttest.r
\name{aldex.ttest}
\alias{aldex.ttest}
\title{Calculate Wilcoxon Rank Sum test and Welch's t-test statistics}
\usage{
aldex.ttest(clr, paired.test = FALSE, hist.plot = FALSE, verbose = FALSE)
}
\arguments{
\item{clr}{An \code{ALDEx2} object. The output of \code{aldex.clr}.}

\item{paired.test}{Toggles whether to calculate paired tests.}

\item{hist.plot}{Toggles whether to plot a histogram of p-values for the
first Dirichlet Monte Carlo instance.}

\item{verbose}{A boolean. Toggles whether to print diagnostic information
while running. Useful for debugging errors on large datasets. Applies
to \code{effect = TRUE}.}
}
\value{
Returns a \code{data.frame} with the following information:
\item{we.ep}{a vector containing the the poseterior predictive p-value of 
 Welch's t-test for each feature }
\item{we.eBH}{a vector containing the corresponding expected value of the
 Benjamini-Hochberg corrected p-value for each feature }
\item{wi.ep}{a vector containing the expected p-value of the Wilcoxon Rank Sum test
 for each feature }
\item{wi.eBH}{a vector containing the corresponding expected value of the
 Benjamini-Hochberg corrected p-value for each feature }
}
\description{
\code{aldex.ttest} calculates the expected values of the Wilcoxon Rank Sum
 test and the posterior predictive value of Welch's t-test on the data
 returned by \code{aldex.clr}.
}
\examples{
data(selex)
#subset for efficiency
selex <- selex[1201:1600,]
conds <- c(rep("NS", 7), rep("S", 7))
x <- aldex.clr(selex, conds, mc.samples=2, denom="all")
ttest.test <- aldex.ttest(x)
}
\references{
Please use the citation given by
 \code{citation(package="ALDEx2")}.
}
\seealso{
\code{\link{aldex}},
 \code{\link{aldex.clr}},
 \code{\link{aldex.ttest}},
 \code{\link{aldex.kw}},
 \code{\link{aldex.glm}},
 \code{\link{aldex.effect}},
 \code{\link{aldex.corr}},
 \code{\link{selex}}
}
\author{
Greg Gloor, Michelle Pistner
}
